#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0205/UEL0205_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Mobile Flak Artillery Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TLandUnit
local TAAFlakArtilleryCannon = import('/lua/terranweapons.lua').TAAFlakArtilleryCannon

###UPGRADE04
local TDFMachineGunWeapon = import('/lua/terranweapons.lua').TDFMachineGunWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0205 = Class(TLandUnit) {
    Weapons = {
        AAGun = Class(TAAFlakArtilleryCannon) {
            PlayOnlyOneSoundCue = true,
        },
		###UPGRADE02
		AAGunUpgrade = Class(TAAFlakArtilleryCannon) {
            PlayOnlyOneSoundCue = true,
        },
		###UPGRADE04
		ALGunUpgrade = Class(TDFMachineGunWeapon) {},
    },

    OnCreate = function(self)
		TLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true) 
			self:HideBone('Upgrade01_02', true)  
			self:HideBone('Upgrade01_03', true)  			
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)	
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        TLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('AAGun', true)
		####UPGRADE02
		self:SetWeaponEnabledByLabel('AAGunUpgrade', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('ALGunUpgrade', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				
				local wep = self:GetWeaponByLabel('AAGun')
				wep:AddDamageMod(bpEnh.AAIDamageMod)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 80,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 300,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetWeaponEnabledByLabel('AAGunUpgrade', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 400,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                 BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 222,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:HideBone('Origine04_01', true)
				self:SetWeaponEnabledByLabel('ALGunUpgrade', true)
				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 1200,
                            Mult = 1.0,
                        },				
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	end,
}

TypeClass = UEL0205