#****************************************************************************
#**
#**  File     :  /cdimage/units/UES0201/UES0201_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Terran Destroyer Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local TSeaUnit = import('/lua/terranunits.lua').TSeaUnit
local WeaponFile = import('/lua/terranweapons.lua')
local TAALinkedRailgun = WeaponFile.TAALinkedRailgun
local TDFGaussCannonWeapon = WeaponFile.TDFGaussCannonWeapon
local TANTorpedoAngler = WeaponFile.TANTorpedoAngler
local TIFSmartCharge = WeaponFile.TIFSmartCharge

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UES0201 = Class(TSeaUnit) {
    DestructionTicks = 200,

    Weapons = {
        FrontTurret01 = Class(TDFGaussCannonWeapon) {},
        BackTurret01 = Class(TDFGaussCannonWeapon) {},
        FrontTurret02 = Class(TAALinkedRailgun) {},
		BackTurret02 = Class(TAALinkedRailgun) {},
        Torpedo01 = Class(TANTorpedoAngler) {},
        AntiTorpedo = Class(TIFSmartCharge) {},
		### UPGRADE CANNONS GRADE 02
		GaussUgradeTurret01 = Class(TDFGaussCannonWeapon) {},
		### UPGRADE ANTI AIR GRADE 02
		AAUpgradeTurret01 = Class(TAALinkedRailgun) {},
		AAUpgradeTurret02 = Class(TAALinkedRailgun) {},
		AAUpgradeTurret03 = Class(TAALinkedRailgun) {},
		### UPGRADE CANNONS GRADE 04
		GaussUgradeTurret02 = Class(TDFGaussCannonWeapon) {},
		GaussUgradeTurret03 = Class(TDFGaussCannonWeapon) {},
		GaussUgradeTurret04 = Class(TDFGaussCannonWeapon) {},
		GaussUgradeTurret05 = Class(TDFGaussCannonWeapon) {},
    },

    RadarThread = function(self)
        local spinner = CreateRotator(self, 'Spinner02', 'x', nil, 0, 90, -90)
        self.Trash:Add(spinner)
        while true do
            WaitFor(spinner)
            spinner:SetTargetSpeed(90)
            WaitFor(spinner)
            spinner:SetTargetSpeed(-90)
        end
    end,
	
    OnCreate = function(self)
		TSeaUnit.OnCreate(self)
		#Grade01
		self:HideBone('Upgrade01_01', true) 
		self:HideBone('Upgrade01_02', true) 
		self:HideBone('Upgrade01_03', true)
		self:HideBone('Upgrade01_04', true)
		self:HideBone('Upgrade01_05', true) 	
		self:HideBone('Upgrade01_06', true) 	 		
		#Grade02
		self:HideBone('Upgrade02_01', true) 
		--self:HideBone('Upgrade02_02', true) 
		self:HideBone('Front_Turret03', true) 
		self:HideBone('Front_Turret04', true) 
		#Grade03
		self:HideBone('Upgrade03_01', true) 
		#Grade04
		self:HideBone('Upgrade04_01', true) 
		#Grade05
		self:HideBone('Upgrade05_01', true)
		self:HideBone('Upgrade05_02', true)
		self:HideBone('Upgrade05_03', true)
		self:HideBone('Upgrade05_04', true)
		self:HideBone('Upgrade05_05', true)
		self:HideBone('Upgrade05_06', true)
		self:HideBone('Upgrade05_07', true)
		self:HideBone('Upgrade05_08', true)
		self:HideBone('Upgrade05_09', true)
		self:HideBone('Upgrade05_10', true)
		self:HideBone('Upgrade05_11', true)
		self:HideBone('Upgrade05_12', true)
		self:HideBone('Upgrade05_13', true)
		self:HideBone('Upgrade05_14', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	


    OnStopBeingBuilt = function(self,builder,layer)
        TSeaUnit.OnStopBeingBuilt(self,builder,layer)
        self.Trash:Add(CreateRotator(self, 'Spinner01', 'y', nil, 180, 0, 180))
        self:ForkThread(self.RadarThread)
		self:SetWeaponEnabledByLabel('GaussUgradeTurret01', false)
		##UPGRADE04
		self:SetWeaponEnabledByLabel('GaussUgradeTurret02', false)
		self:SetWeaponEnabledByLabel('GaussUgradeTurret03', false)
		self:SetWeaponEnabledByLabel('GaussUgradeTurret04', false)
		self:SetWeaponEnabledByLabel('GaussUgradeTurret05', false)
		##UPGRADE04
		self:SetWeaponEnabledByLabel('AAUpgradeTurret01', false)
		self:SetWeaponEnabledByLabel('AAUpgradeTurret02', false)
		self:SetWeaponEnabledByLabel('AAUpgradeTurret03', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				local wep01 = self:GetWeaponByLabel('FrontTurret01') 
				local wep02 = self:GetWeaponByLabel('BackTurret01')
				local wep03 = self:GetWeaponByLabel('FrontTurret02') 
				local wep04 = self:GetWeaponByLabel('BackTurret02') 
				local wep05 = self:GetWeaponByLabel('BackTurret02')  
				local wep06 = self:GetWeaponByLabel('Torpedo01')   		
				##UPGRADE02
				local wep12 = self:GetWeaponByLabel('AAUpgradeTurret01') 
				local wep13 = self:GetWeaponByLabel('AAUpgradeTurret02') 
				local wep14 = self:GetWeaponByLabel('AAUpgradeTurret03') 
				local wep07 = self:GetWeaponByLabel('GaussUgradeTurret01') 
				##UPGRADE04
				local wep08 = self:GetWeaponByLabel('GaussUgradeTurret02')
				local wep09 = self:GetWeaponByLabel('GaussUgradeTurret03') 
				local wep10 = self:GetWeaponByLabel('GaussUgradeTurret04') 	
				local wep11 = self:GetWeaponByLabel('GaussUgradeTurret05') 
				##UPGRADE04END		
				wep01:ChangeMaxRadius(66)
				wep02:ChangeMaxRadius(66)
				wep03:ChangeMaxRadius(66)
				wep04:ChangeMaxRadius(66)
				wep05:ChangeMaxRadius(66)
				wep06:ChangeMaxRadius(66)
				wep07:ChangeMaxRadius(66)
				wep08:ChangeMaxRadius(66)
				wep09:ChangeMaxRadius(66)
				wep10:ChangeMaxRadius(66)
				wep11:ChangeMaxRadius(66)
				wep12:ChangeMaxRadius(66)
				wep13:ChangeMaxRadius(66)
				wep14:ChangeMaxRadius(66)
				self:SetIntelRadius('Radar', bp.NewOmniRadius or 46)
				self:SetIntelRadius('Sonar', bp.NewOmniRadius or 46)
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				self:ShowBone('Upgrade01_05', true)
				self:ShowBone('Upgrade01_06', true)
					
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			

            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				
				self:SetWeaponEnabledByLabel('GaussUgradeTurret01', true)
				self:SetWeaponEnabledByLabel('AAUpgradeTurret01', true)
				self:SetWeaponEnabledByLabel('AAUpgradeTurret02', true)
				self:SetWeaponEnabledByLabel('AAUpgradeTurret03', true)
				self:SetWeaponEnabledByLabel('FrontTurret02', false)
			
				self:ShowBone('Upgrade02_01', true)
				--self:ShowBone('Upgrade02_02', true)
				self:ShowBone('Front_Turret03', true) 
				self:ShowBone('Front_Turret04', true)
				self:HideBone('Upgrade05_13', true)
				self:HideBone('Upgrade05_14', true)				
				
				self:HideBone('Origine01', true)
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
			
				self:HideBone('Origine02', true)
				self:ShowBone('Upgrade03_01', true)
				local wep = self:GetWeaponByLabel('AntiTorpedo')  				
				wep:ChangeRateOfFire(0.5)
				wep:ChangeMaxRadius(36)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 3000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:HideBone('Upgrade05_01', true)
				self:HideBone('Upgrade05_02', true)
				self:HideBone('Upgrade05_03', true)
				self:HideBone('Upgrade05_04', true)
				self:HideBone('Upgrade05_05', true)
				self:HideBone('Upgrade05_06', true)
				self:HideBone('Upgrade05_07', true)
				self:HideBone('Upgrade05_08', true)
				self:HideBone('Upgrade05_09', true)
				self:HideBone('Upgrade05_10', true)
				self:HideBone('Upgrade05_11', true)
				self:HideBone('Upgrade05_12', true)
				self:HideBone('Upgrade05_13', true)
				self:HideBone('Upgrade05_14', true)
				self:SetWeaponEnabledByLabel('GaussUgradeTurret02', true)
				self:SetWeaponEnabledByLabel('GaussUgradeTurret03', true)
				self:SetWeaponEnabledByLabel('GaussUgradeTurret04', true)
				self:SetWeaponEnabledByLabel('GaussUgradeTurret05', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	

				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				self:ShowBone('Upgrade05_03', true)
				self:ShowBone('Upgrade05_04', true)
				self:ShowBone('Upgrade05_05', true)
				self:ShowBone('Upgrade05_06', true)
				self:ShowBone('Upgrade05_07', true)
				self:ShowBone('Upgrade05_08', true)
				self:ShowBone('Upgrade05_09', true)
				self:ShowBone('Upgrade05_10', true)
				self:ShowBone('Upgrade05_11', true)
				self:ShowBone('Upgrade05_12', true)
				self:ShowBone('Upgrade05_13', true)
				self:ShowBone('Upgrade05_14', true)
				
				local wep01 = self:GetWeaponByLabel('FrontTurret01') 
				local wep02 = self:GetWeaponByLabel('BackTurret01')
				local wep03 = self:GetWeaponByLabel('FrontTurret02') 
				local wep04 = self:GetWeaponByLabel('BackTurret02') 
				local wep05 = self:GetWeaponByLabel('BackTurret02')  
				local wep06 = self:GetWeaponByLabel('Torpedo01')   				
				local wep07 = self:GetWeaponByLabel('GaussUgradeTurret01') 
				local wep08 = self:GetWeaponByLabel('GaussUgradeTurret02')
				local wep09 = self:GetWeaponByLabel('GaussUgradeTurret03') 
				local wep10 = self:GetWeaponByLabel('GaussUgradeTurret04') 	
				local wep11 = self:GetWeaponByLabel('GaussUgradeTurret05') 	
				local wep12 = self:GetWeaponByLabel('AAUpgradeTurret01') 
				local wep13 = self:GetWeaponByLabel('AAUpgradeTurret02') 
				local wep14 = self:GetWeaponByLabel('AAUpgradeTurret03') 				
				
				wep01:ChangeRateOfFire(0.5)
				wep02:ChangeRateOfFire(0.35)
				wep07:ChangeRateOfFire(0.35)
				wep08:ChangeRateOfFire(0.35)
				wep09:ChangeRateOfFire(0.35)
				wep10:ChangeRateOfFire(0.35)
				wep11:ChangeRateOfFire(0.35)
				
				wep04:ChangeRateOfFire(0.95)
				wep05:ChangeRateOfFire(0.95)
				wep11:ChangeRateOfFire(0.95)
				wep12:ChangeRateOfFire(0.95)
				wep13:ChangeRateOfFire(0.95)
				
				wep06:ChangeRateOfFire(0.5)			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 5000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
end,			
	
}

TypeClass = UES0201