#****************************************************************************
#**
#**  File     :  /cdimage/units/URL0111/URL0111_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Cybran Mobile Missile Launcher Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local CLandUnit = import( MyModPath .. '/hook/lua/cybranunits.lua' ).CLandUnit

local Buff = import('/lua/sim/Buff.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')

local CIFMissileLoaWeapon = import('/lua/cybranweapons.lua').CIFMissileLoaWeapon

#########UPGRADE04
local CAANanoDartWeapon = import('/lua/cybranweapons.lua').CAANanoDartWeapon

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

URL0111 = Class(CLandUnit) {
    Weapons = {
        MissileRack = Class(CIFMissileLoaWeapon) {},
		################ UPGRADE02
		MissileRack01 = Class(CIFMissileLoaWeapon) {

		},
		MissileRack02 = Class(CIFMissileLoaWeapon) {

		},
		################ UPGRADE04
		AAGun01 = Class(CAANanoDartWeapon) {},
    },
	
    OnCreate = function(self)
		CLandUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        CLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MissileRack', true)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('MissileRack01', false)
		self:SetWeaponEnabledByLabel('MissileRack02', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('AAGun01', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
			
				local wep = self:GetWeaponByLabel('MissileRack')
    		    wep:ChangeRateOfFire(0.4)   
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)	
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 300,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				self:SetWeaponEnabledByLabel('MissileRack01', true)
				self:SetWeaponEnabledByLabel('MissileRack02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 400,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then						
				self:ShowBone('Upgrade03_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				local wep1 = self:GetWeaponByLabel('MissileRack')
				wep1:AddDamageMod(bpEnh.TMLIDamageMod)
				
				local wep2 = self:GetWeaponByLabel('MissileRack01')
				wep2:AddDamageMod(bpEnh.TMLIDamageMod)
				
				local wep3 = self:GetWeaponByLabel('MissileRack02')
				wep3:AddDamageMod(bpEnh.TMLIDamageMod)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				
				self:SetWeaponEnabledByLabel('AAGun01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then		
				self:ShowBone('Upgrade05_01', true)

			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
            end
		end	
	end,	
	
	
	OnKilled = function(self, instigator, type, overkillRatio)
	CLandUnit.OnKilled(self, instigator, type, overkillRatio)
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if not bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			--self:Destroy()	
			end
		end			
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()		
			
			ForkThread(function()
			self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranRelife/CybranRelife_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
			
			WaitSeconds(6.5)			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)	
			self:Destroy()
			end)
			
			end
		end
		
    end,
		
}

TypeClass = URL0111
