#****************************************************************************
#**
#**  File     :  /cdimage/units/URS0202/URS0202_script.lua
#**  Author(s):  David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Cybran Cruiser Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local CSeaUnit = import('/lua/cybranunits.lua').CSeaUnit
local CybranWeaponsFile = import('/lua/cybranweapons.lua')
local CDFLaserDisintegratorWeapon = CybranWeaponsFile.CDFLaserDisintegratorWeapon02
local CAMZapperWeapon = import('/lua/cybranweapons.lua').CAMZapperWeapon
local CDFProtonCannonWeapon = CybranWeaponsFile.CDFProtonCannonWeapon

####UPGRADE02
local CDFParticleCannonWeapon = import('/lua/cybranweapons.lua').CDFParticleCannonWeapon
###UPGRADE04
local CAABurstCloudFlakArtilleryWeapon = import('/lua/cybranweapons.lua').CAABurstCloudFlakArtilleryWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

URS0202 = Class(CSeaUnit) {
    Weapons = {
        ParticleGun = Class(CDFLaserDisintegratorWeapon) {},
		 ParticleGun02 = Class(CDFProtonCannonWeapon) {},
        Zapper = Class(CAMZapperWeapon) {},
		##UPGRADE02
		LateralGaucheGun01 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralGaucheGun02 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralGaucheGun03 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralGaucheGun04 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralDroitGun05 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralDroitGun06 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralDroitGun07 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },
		LateralDroitGun08 = Class(CDFParticleCannonWeapon) {
            FxMuzzleFlash = {'/effects/emitters/particle_cannon_muzzle_02_emit.bp'},
        },	
		###UPGRADE03
		ParticleGun03 = Class(CDFLaserDisintegratorWeapon) {},			
		###UPGRADE04
		ParticleGun04 = Class(CDFLaserDisintegratorWeapon) {},	
		AAGun01 = Class(CAABurstCloudFlakArtilleryWeapon) {
		  PlayFxWeaponUnpackSequence = function(self)
                if not self.SpinManip03 then 
                    self.SpinManip03 = CreateRotator(self.unit, 'Rotator03', 'z', nil, 270, 270, 80)
                    self.SpinManip03:SetPrecedence(10)
                    self.unit.Trash:Add(self.SpinManip03)
                end
				if not self.SpinManip04 then 
                    self.SpinManip04 = CreateRotator(self.unit, 'Rotator04', 'z', nil, 270, 270, 80)
                    self.SpinManip04:SetPrecedence(10)
                    self.unit.Trash:Add(self.SpinManip04)
                end
                if self.SpinManip03 then
                    self.SpinManip03:SetTargetSpeed(270)
                end
				if self.SpinManip04 then
                    self.SpinManip04:SetTargetSpeed(270)
                end
                CAABurstCloudFlakArtilleryWeapon.PlayFxWeaponUnpackSequence(self)
            end,

            PlayFxWeaponPackSequence = function(self)
                if self.SpinManip03 then
                    self.SpinManip03:SetTargetSpeed(0)
                end
				if self.SpinManip04 then
                    self.SpinManip04:SetTargetSpeed(0)
                end
                CAABurstCloudFlakArtilleryWeapon.PlayFxWeaponPackSequence(self)
            end,		
		},
		AAGun02 = Class(CAABurstCloudFlakArtilleryWeapon) {
		  PlayFxWeaponUnpackSequence = function(self)
                if not self.SpinManip01 then 
                    self.SpinManip01 = CreateRotator(self.unit, 'Rotator01', 'z', nil, 270, 270, 270)
                    self.SpinManip01:SetPrecedence(10)
                    self.unit.Trash:Add(self.SpinManip01)
                end
				if not self.SpinManip02 then 
                    self.SpinManip02 = CreateRotator(self.unit, 'Rotator02', 'z', nil, 270, 270, 270)
                    self.SpinManip02:SetPrecedence(10)
                    self.unit.Trash:Add(self.SpinManip02)
                end
                if self.SpinManip01 then
                    self.SpinManip01:SetTargetSpeed(270)
                end
				if self.SpinManip02 then
                    self.SpinManip02:SetTargetSpeed(270)
                end
                CAABurstCloudFlakArtilleryWeapon.PlayFxWeaponUnpackSequence(self)
            end,

            PlayFxWeaponPackSequence = function(self)
                if self.SpinManip01 then
                    self.SpinManip01:SetTargetSpeed(0)
                end
				if self.SpinManip02 then
                    self.SpinManip02:SetTargetSpeed(0)
                end
                CAABurstCloudFlakArtilleryWeapon.PlayFxWeaponPackSequence(self)
            end,
		},
    },
    
    OnCreate = function(self)
        CSeaUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		###UPGRADE02
		self:HideBone('front_turret01', true)
		self:HideBone('CannonLat01', true)
		self:HideBone('CannonLat02', true)
		self:HideBone('CannonLat03', true)
		self:HideBone('CannonLat04', true)
		self:HideBone('CannonLat05', true)
		self:HideBone('CannonLat06', true)
		self:HideBone('CannonLat07', true)
		self:HideBone('CannonLat08', true)
		###UPGRADE03
		self:HideBone('launcher_turret', true)
		self:HideBone('launcher_turret01', true)
		###UPGRADE04
		self:HideBone('Upgrade04_01', true)
		self:HideBone('Upgrade04_02', true)
    end,
    
    OnStopBeingBuilt = function(self,builder,layer)
        CSeaUnit.OnStopBeingBuilt(self,builder,layer)	

		###UPGRADE01

		###UPGRADE02	
		self:SetWeaponEnabledByLabel('LateralGaucheGun01', false)
		self:SetWeaponEnabledByLabel('LateralGaucheGun02', false)
		self:SetWeaponEnabledByLabel('LateralGaucheGun03', false)
		self:SetWeaponEnabledByLabel('LateralGaucheGun04', false)
		self:SetWeaponEnabledByLabel('LateralDroitGun05', false)
		self:SetWeaponEnabledByLabel('LateralDroitGun06', false)
		self:SetWeaponEnabledByLabel('LateralDroitGun07', false)
		self:SetWeaponEnabledByLabel('LateralDroitGun08', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('ParticleGun03', false)
		###UPGRADE04
		self:SetWeaponEnabledByLabel('AAGun01', false)
		self:SetWeaponEnabledByLabel('AAGun02', false)
		self:SetWeaponEnabledByLabel('ParticleGun04', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
		self:ShowBone('Upgrade01_01', true)
		self:ShowBone('Upgrade01_02', true)
		local wep01 = self:GetWeaponByLabel('ParticleGun') 
		local wep02 = self:GetWeaponByLabel('ParticleGun02')  
		wep01:AddDamageMod(bpEnh.DesintegratorIDamageMod) 
		wep02:AddDamageMod(bpEnh.ProtonIDamageMod) 
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			

            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
			self:SetWeaponEnabledByLabel('LateralGaucheGun01', true)
			self:SetWeaponEnabledByLabel('LateralGaucheGun02', true)
			self:SetWeaponEnabledByLabel('LateralGaucheGun03', true)
			self:SetWeaponEnabledByLabel('LateralGaucheGun04', true)
			self:SetWeaponEnabledByLabel('LateralDroitGun05', true)
			self:SetWeaponEnabledByLabel('LateralDroitGun06', true)
			self:SetWeaponEnabledByLabel('LateralDroitGun07', true)
			self:SetWeaponEnabledByLabel('LateralDroitGun08', true)			
				self:ShowBone('CannonLat01', true)
				self:ShowBone('CannonLat02', true)
				self:ShowBone('CannonLat03', true)
				self:ShowBone('CannonLat04', true)
				self:ShowBone('CannonLat05', true)
				self:ShowBone('CannonLat06', true)
				self:ShowBone('CannonLat07', true)
				self:ShowBone('CannonLat08', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then			
				self:HideBone('Light_turret01', true)
				self:ShowBone('front_turret01', true)
				self:SetWeaponEnabledByLabel('ParticleGun03', true)
				self:SetWeaponEnabledByLabel('ParticleGun02', false)				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			self:ShowBone('launcher_turret', true)
			self:ShowBone('launcher_turret01', true)
			self:SetWeaponEnabledByLabel('AAGun01', true)
			self:SetWeaponEnabledByLabel('AAGun02', true)	
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:HideBone('Origine01', true)
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:SetWeaponEnabledByLabel('ParticleGun04', true)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 3000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	end,	
	
}

TypeClass = URS0202