#****************************************************************************
#**
#**  File     :  /data/units/XAL0203/XAL0203_script.lua
#**  Author(s):  Jessica St. Croix
#**
#**  Summary  :  Aeon Assault Tank Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local AHoverLandUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).AHoverLandUnit

local ADFQuantumAutogunWeapon = import('/lua/aeonweapons.lua').ADFQuantumAutogunWeapon
local Buff = import('/lua/sim/Buff.lua')

local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XAL0203 = Class( AHoverLandUnit ) {
    Weapons = {
        MainGun = Class(ADFQuantumAutogunWeapon) {},
		###UPGRADE02
		UpgradeGun01 = Class(ADFQuantumAutogunWeapon) {},
		UpgradeGun02 = Class(ADFQuantumAutogunWeapon) {},
		###UPGRADE04
		UpgradeGun03 = Class(ADFQuantumAutogunWeapon) {},
		UpgradeGun04 = Class(ADFQuantumAutogunWeapon) {},
		UpgradeGun05 = Class(ADFQuantumAutogunWeapon) {},
    },
	
    OnCreate = function(self)
		AHoverLandUnit.OnCreate(self)
			########UPGRADE 01
			self:HideBone('Upgrade01_02', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			self:HideBone('Upgrade04_03', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        AHoverLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		####UPGRADE02
		self:SetWeaponEnabledByLabel('UpgradeGun01', false)
		self:SetWeaponEnabledByLabel('UpgradeGun02', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('UpgradeGun03', false)
		self:SetWeaponEnabledByLabel('UpgradeGun04', false)
		self:SetWeaponEnabledByLabel('UpgradeGun05', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,		

	#Level#
	OnVeteran = function ( self, enh )
	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then

				self:ShowBone('Upgrade01_02', true)
				
				local wep = self:GetWeaponByLabel('MainGun') 
				wep:ChangeMaxRadius(22)
				wep:AddDamageMod(bpEnh.BolterIDamageMod)		
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
			
				self:ShowBone('Upgrade02_01', true)

				self:HideBone('Upgrade03_02', true)
				self:HideBone('Upgrade03_03', true)
				self:HideBone('Upgrade04_02', true)
				self:HideBone('Upgrade04_03', true)
				self:HideBone('Origine03_01', true)
				
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 400,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				
				local wep1 = self:GetWeaponByLabel('MainGun') 
				wep1:ChangeMaxRadius(26)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(26)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(26)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				
				self:SetWeaponEnabledByLabel('UpgradeGun03', true)
				self:SetWeaponEnabledByLabel('UpgradeGun04', true)
				self:SetWeaponEnabledByLabel('UpgradeGun05', true)
				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
			ForkThread(function()
				self:AddToggleCap('RULEUTC_ShieldToggle')
				self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
				self:SetMaintenanceConsumptionActive()
				self:CreatePersonalShield(bpEnh)
            end)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
            end
		end			
end,	
	
}

TypeClass = XAL0203
