#****************************************************************************
#**
#**  File     :  /main/data/Units/XSA0204/XSA0204_script.lua
#**  Author(s):  Greg Kohne, Gordon Duclos
#**
#**  Summary  :  Seraphim Torpedo Bomber Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local SAirUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SAirUnit

local SeraphimWeapons = import('/lua/seraphimweapons.lua')
local SANHeavyCavitationTorpedo = SeraphimWeapons.SANHeavyCavitationTorpedo

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSA0204 = Class(SAirUnit) {
    Weapons = {
        Bomb = Class(SANHeavyCavitationTorpedo) {},
		Bomb2 = Class(SANHeavyCavitationTorpedo) {},
		Bomb3 = Class(SANHeavyCavitationTorpedo) {},
    },
	
	
   OnCreate = function(self)
		SAirUnit.OnCreate(self)

			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SAirUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('Bomb', true)
			###UPGRADE02
	        self:SetWeaponEnabledByLabel('Bomb2', false)  
			###UPGRADE04
	        self:SetWeaponEnabledByLabel('Bomb3', false)  
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then

				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				local wep = self:GetWeaponByLabel('Bomb')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)

				
				local wep2 = self:GetWeaponByLabel('Bomb2')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	

				
				local wep3 = self:GetWeaponByLabel('Bomb3')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	 
			
				

				
				hasHEBI = true   
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then

				self:SetWeaponEnabledByLabel('Bomb2', true)  
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				
				local wep = self:GetWeaponByLabel('Bomb')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)
				wep:ChangeRateOfFire(1.37)  
				
				local wep2 = self:GetWeaponByLabel('Bomb2')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	
				wep2:ChangeRateOfFire(1.37)  
				
				local wep3 = self:GetWeaponByLabel('Bomb3')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	 
				wep3:ChangeRateOfFire(1.37)  

				
				hasHEBI = true
				hasHEBII = true 
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },
					MaxHealth = {
                            Add = 200,
                            Mult = 1.0,
						},						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then

				
				self:SetWeaponEnabledByLabel('Bomb3', true)  
				
				hasHEBI = true
				hasHEBII = true   
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end		
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then			

				self.Effect1 = CreateAttachedEmitter(self,'XSA0204',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 20,
                            Mult = 1,
                        },					
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,		
			
		
}
TypeClass = XSA0204