#****************************************************************************
#**
#**  File     :  /units/XSS0202/XSS0202_script.lua
#**  Author(s):  Drew Staltman, Gordon Duclos, Aaron Lundquist
#**
#**  Summary  :  Seraphim Cruiser Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local SeraphimWeapons = import('/lua/seraphimweapons.lua')
local SSeaUnit = import('/lua/seraphimunits.lua').SSeaUnit
local SLaanseMissileWeapon = SeraphimWeapons.SLaanseMissileWeapon
local SAAOlarisCannonWeapon = SeraphimWeapons.SAAOlarisCannonWeapon
local SAAShleoCannonWeapon = SeraphimWeapons.SAAShleoCannonWeapon

local SAMElectrumMissileDefense = SeraphimWeapons.SAMElectrumMissileDefense

###UPGRADE02
local SDFThauCannon = SeraphimWeapons.SDFThauCannon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false
XSS0202 = Class(SSeaUnit) {
    Weapons = {
        Missile = Class(SLaanseMissileWeapon) {},
		RightAAGun = Class(SAAShleoCannonWeapon) {},
		LeftAAGun = Class(SAAOlarisCannonWeapon) {},
        AntiMissile = Class(SAMElectrumMissileDefense) {},
		###UPGRADE2
		Upgrade02_01Turret = Class(SDFThauCannon) {},
		Upgrade02_02Turret = Class(SDFThauCannon) {},
		####UPGRADE3
		Missile02 = Class(SLaanseMissileWeapon) {},
		Missile03 = Class(SLaanseMissileWeapon) {},
		####UPGRADE4
		RightAAGun01 = Class(SAAShleoCannonWeapon) {},
		LeftAAGun01 = Class(SAAOlarisCannonWeapon) {},
    },

    BackWakeEffect = {},
	
	
    OnCreate = function(self)
        SSeaUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)

		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		self:HideBone('Upgrade02_02', true) 		
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self:HideBone('Upgrade05_02', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false		
    end,	
	
    OnStopBeingBuilt = function(self, builder,layer)
        SSeaUnit.OnStopBeingBuilt(self, builder,layer)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('Upgrade02_01Turret', false)
		self:SetWeaponEnabledByLabel('Upgrade02_02Turret', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('Missile02', false)
		self:SetWeaponEnabledByLabel('Missile03', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('RightAAGun01', false)
		self:SetWeaponEnabledByLabel('LeftAAGun01', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				self:ShowBone('Upgrade01_01', true)
				local wep01 = self:GetWeaponByLabel('RightAAGun')
				wep01:ChangeRateOfFire(2.6)
				wep01:ChangeMaxRadius(85)
				local wep02 = self:GetWeaponByLabel('LeftAAGun')
				wep02:ChangeRateOfFire(4)
				wep02:ChangeMaxRadius(59)
				local wep03 = self:GetWeaponByLabel('RightAAGun01')
				wep03:ChangeRateOfFire(2.6)
				wep03:ChangeMaxRadius(85)
				local wep04 = self:GetWeaponByLabel('LeftAAGun01')
				wep04:ChangeRateOfFire(4)
				wep04:ChangeMaxRadius(59)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			

            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true) 
				self:SetWeaponEnabledByLabel('Upgrade02_01Turret', true)
				self:SetWeaponEnabledByLabel('Upgrade02_02Turret', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true) 
				self:SetWeaponEnabledByLabel('Missile02', true)
				self:SetWeaponEnabledByLabel('Missile03', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2600,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:SetWeaponEnabledByLabel('RightAAGun01', true)
				self:SetWeaponEnabledByLabel('LeftAAGun01', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 3200,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	end,	
			
	
	
}

TypeClass = XSS0202