#****************************************************************************
#**
#**  File     :  /Mods/ExpeWars/units/UEL0305/UEL0305_script.lua
#**  Author(s):  John Comes, David Tomandl, Gordon Duclos
#**
#**  Summary  :  UEF T3 Heavy Tank Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local TLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TLandUnit

local WeaponFile = import('/lua/terranweapons.lua')
local TAALinkedRailgun = WeaponFile.TAALinkedRailgun
local TDFGaussCannonWeapon = WeaponFile.TDFGaussCannonWeapon
local TIFCruiseMissileUnpackingLauncher = WeaponFile.TIFCruiseMissileUnpackingLauncher

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0305 = Class(TLandUnit) {
    Weapons = {
		FrontTurret = Class(TDFGaussCannonWeapon) {},
		#######UPGRADE02
		BackTurret = Class(TDFGaussCannonWeapon) {},
		####UPGRADE 3
        MissileWeapon01 = Class(TIFCruiseMissileUnpackingLauncher) {},
		MissileWeapon02 = Class(TIFCruiseMissileUnpackingLauncher) {},
    },
	
	
	OnCreate = function(self)
        TLandUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		self:HideBone('Upgrade01_03', true)
		self:HideBone('Upgrade01_04', true)
		self:HideBone('Upgrade01_05', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		self:HideBone('Upgrade03_03', true)
		self:HideBone('Upgrade03_04', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,	
	
	OnStopBeingBuilt = function(self, builder,layer)
        TLandUnit.OnStopBeingBuilt(self, builder,layer)
		self:SetWeaponEnabledByLabel('FrontTurret', true)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('BackTurret', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('MissileWeapon01', false)
		self:SetWeaponEnabledByLabel('MissileWeapon02', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,	
	
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 10%
				local wep = self:GetWeaponByLabel('FrontTurret')
				wep:AddDamageMod(bpEnh.PlasmaIDamageMod)
				###Bones
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				self:ShowBone('Upgrade01_05', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFI',
                    DisplayName = 'UEFHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 109.9,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon				
				self:ShowBone('Upgrade02_01', true)
				
				self:SetWeaponEnabledByLabel('BackTurret', true)

				self:HideBone('Upgrade03_01', true)
				self:HideBone('Upgrade03_02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFII',
                    DisplayName = 'UEFHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 10,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
			
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				self:SetWeaponEnabledByLabel('MissileWeapon01', true)
				self:SetWeaponEnabledByLabel('MissileWeapon02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIII',
                    DisplayName = 'UEFHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 35,
                            Mult = 0.9,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIV',
                    DisplayName = 'UEFHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 277,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				###Speed -30%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFV',
                    DisplayName = 'UEFHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 195,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFV')
		end		
	end,		
    
}

TypeClass = UEL0305