#****************************************************************************
#**
#**  File     :  /cdimage/units/XEL0305/XEL0305_script.lua
#**
#**  Summary  :  UEF Siege Assault Bot Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local TerranWeaponFile = import('/lua/terranweapons.lua')

local TWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TWalkingLandUnit
local TWalkingLandUnit = import('/lua/terranunits.lua').TWalkingLandUnit
local TDFIonizedPlasmaCannon = TerranWeaponFile.TDFIonizedPlasmaCannon
local TIFCruiseMissileUnpackingLauncher = TerranWeaponFile.TIFCruiseMissileUnpackingLauncher

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false


XEL0305 = Class(TWalkingLandUnit) {

    Weapons = {
        PlasmaCannon01 = Class(TDFIonizedPlasmaCannon) {},
		####UPGRADE 2
		PlasmaCannon02 = Class(TDFIonizedPlasmaCannon) {},
		####UPGRADE 3
        MissileWeapon01 = Class(TIFCruiseMissileUnpackingLauncher) {},
    },
	
 OnCreate = function(self)
        TWalkingLandUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		self:HideBone('Upgrade03_03', true)
		self:HideBone('Upgrade03_04', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		self:HideBone('Upgrade04_02', true)
		self:HideBone('Upgrade04_03', true)
		self:HideBone('Upgrade04_05', true)
		self:HideBone('Upgrade04_06', true)
		self:HideBone('Upgrade04_07', true)
		self:HideBone('Upgrade04_08', true)
		self:HideBone('Upgrade04_09', true)
		self:HideBone('Upgrade04_10', true)
		self:HideBone('Upgrade04_11', true)
		self:HideBone('Upgrade04_12', true)
		self:HideBone('Upgrade04_13', true)
		self:HideBone('Upgrade04_14', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self:HideBone('Upgrade05_02', true)
		self:HideBone('Upgrade05_03', true)
		self:HideBone('Upgrade05_04', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,	
	
	OnStopBeingBuilt = function(self, builder,layer)
        TWalkingLandUnit.OnStopBeingBuilt(self, builder,layer)
		self:SetWeaponEnabledByLabel('PlasmaCannon01', true)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('PlasmaCannon02', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('MissileWeapon01', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,	
	
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 10%
				local wep = self:GetWeaponByLabel('PlasmaCannon01')
				wep:AddDamageMod(bpEnh.PlasmaIDamageMod)
				###Bones
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFI',
                    DisplayName = 'UEFHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 850,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon				
				self:ShowBone('Upgrade02_01', true)
				self:SetWeaponEnabledByLabel('PlasmaCannon02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFII',
                    DisplayName = 'UEFHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 100,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				self:SetWeaponEnabledByLabel('MissileWeapon01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIII',
                    DisplayName = 'UEFHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				self:ShowBone('Upgrade04_04', true)
				self:ShowBone('Upgrade04_05', true)
				self:ShowBone('Upgrade04_06', true)
				self:ShowBone('Upgrade04_07', true)
				self:ShowBone('Upgrade04_08', true)
				self:ShowBone('Upgrade04_09', true)
				self:ShowBone('Upgrade04_10', true)
				self:ShowBone('Upgrade04_11', true)
				self:ShowBone('Upgrade04_12', true)
				self:ShowBone('Upgrade04_13', true)
				self:ShowBone('Upgrade04_14', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIV',
                    DisplayName = 'UEFHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 2130,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				self:ShowBone('Upgrade05_03', true)
				self:ShowBone('Upgrade05_04', true)
				###Speed -30%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFV',
                    DisplayName = 'UEFHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 1400,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFV')
		end		
	end,		
    	

}

TypeClass = XEL0305