#****************************************************************************
#**
#**  File     :  /cdimage/units/UEB2301/UEB2301_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Heavy Gun Tower Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local TStructureUnit = import('/lua/terranunits.lua').TStructureUnit
local TDFGaussCannonWeapon = import('/lua/terranweapons.lua').TDFGaussCannonWeapon
local WeaponsFile = import('/lua/terranweapons.lua')
local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtils = import('/lua/effectutilities.lua')
local TIFCommanderDeathWeapon = WeaponsFile.TIFCommanderDeathWeapon
local TSAMLauncher = WeaponsFile.TSAMLauncher
local TDFLightPlasmaCannonWeapon = WeaponsFile.TDFLightPlasmaCannonWeapon

BRNT3SHPD = Class(TStructureUnit) {
    Weapons = {
        Gauss01 = Class(TDFGaussCannonWeapon) {
            FxMuzzleFlash = EffectTemplate.TPlasmaGatlingCannonMuzzleFlash,
			            FxMuzzleFlashScale = 3.75, 
        },     
        DeathWeapon = Class(TIFCommanderDeathWeapon) {
        },
        MissileRack01 = Class(TSAMLauncher) {
	},
        SmallTurretGun01 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun02 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun03 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun04 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun05 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun06 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun07 = Class(TDFLightPlasmaCannonWeapon) {
        },
        SmallTurretGun08 = Class(TDFLightPlasmaCannonWeapon) {
        },
    },
}

TypeClass = BRNT3SHPD