--[[#######################################################################
#  File     :  /hook/lua/seraphweapons.lua
#  Author(s):  Greg Kohne, Gordon Duclos, Matt Vainio, Aaron Lundquist,
#  Summary  :  Seraphim projectile base class definitions for Exp.Wars
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal -> Restructuration
#  Rev.Date :  07 avril 2010
#  -----------------------------
#  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


local DefaultProjectileFile = import('/lua/sim/defaultprojectiles.lua')
local EmitterProjectile = DefaultProjectileFile.EmitterProjectile
local MultiPolyTrailProjectile = DefaultProjectileFile.MultiPolyTrailProjectile 
local SingleBeamProjectile = DefaultProjectileFile.SingleBeamProjectile
local SinglePolyTrailProjectile = DefaultProjectileFile.SinglePolyTrailProjectile

local EffectTemplate = import( '/lua/EffectTemplates.lua' )

local util = import( '/lua/utilities.lua' )
local RandomInt = util.GetRandomInt


------------------------------------------------------------------------
#  SERAPHIM HEAVY QUARNON ORBITAL CANNON
#------------------------------------------------------------------------

SHeavyQuarnonOrbitalCannon = Class( MultiPolyTrailProjectile ) {
	FxImpactLand = EffectTemplate.SHeavyQuarnonCannonLandHit,
    FxImpactNone = EffectTemplate.SHeavyQuarnonCannonHit,
    FxImpactProp = EffectTemplate.SHeavyQuarnonCannonHit,    
    FxImpactUnit = EffectTemplate.SHeavyQuarnonCannonUnitHit,
    PolyTrails = EffectTemplate.SHeavyQuarnonCannonProjectilePolyTrails,
    PolyTrailOffset = { 0, 0, 0 },
    FxTrails = EffectTemplate.SHeavyQuarnonCannonProjectileFxTrails,
    FxImpactWater = EffectTemplate.SHeavyQuarnonCannonWaterHit,
}
