--[[#######################################################################
#  File     :  /hook/lua/modprojectiles.lua
#  Author(s):  John Comes, Gordon Duclos
#  Summary  :  PROJECTILES SCRIPTS
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  jj mmmmm aaaa
#  -----------------------------
#  Revis.by :  Manimal -> Restructuration + Corrections Mineures
#  Rev.Date :  07 avril 2010
#  -----------------------------
#  Revis.by :  AsdrubaelVect
#  Rev.Date :  31 juillet 2011 -> UnitTeleport06
#  -----------------------------
#  Revis.by :  nnnnnnnn
#  Rev.Date :  jj mmmmm aaaa
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


local DefaultProjectileFile = import('/lua/sim/defaultprojectiles.lua')
local EmitterProjectile = DefaultProjectileFile.EmitterProjectile
local MultiBeamProjectile = DefaultProjectileFile.MultiBeamProjectile
local MultiCompositeEmitterProjectile = DefaultProjectileFile.MultiCompositeEmitterProjectile
local MultiPolyTrailProjectile = DefaultProjectileFile.MultiPolyTrailProjectile
local NullShell = DefaultProjectileFile.NullShell
local OnWaterEntryEmitterProjectile = DefaultProjectileFile.OnWaterEntryEmitterProjectile
local SingleBeamProjectile = DefaultProjectileFile.SingleBeamProjectile
local SingleCompositeEmitterProjectile = DefaultProjectileFile.SingleCompositeEmitterProjectile
local SinglePolyTrailProjectile = DefaultProjectileFile.SinglePolyTrailProjectile

local DepthCharge = import('/lua/defaultantiprojectile.lua').DepthCharge

local Projectile = import('/lua/sim/projectile.lua').Projectile

local DefaultExplosion = import('/lua/defaultexplosions.lua')

local util = import('/lua/utilities.lua')
local GetRandomFloat = util.GetRandomFloat
local EffectTemplate = import('/lua/EffectTemplates.lua')

TeleportProjectile = Class(SinglePolyTrailProjectile) {
	FxImpactTrajectoryAligned = false,
    PolyTrail = '/effects/emitters/antimatter_polytrail_01_emit.bp',
    PolyTrailOffset = 0,

    # Hit Effects
    FxImpactUnit = EffectTemplate.TAntiMatterShellHit01,
    FxImpactProp = EffectTemplate.TAntiMatterShellHit01,
    FxImpactLand = EffectTemplate.TAntiMatterShellHit01,
    FxLandHitScale = 1,
    FxImpactUnderWater = {},

}
