--[[#######################################################################
#  File     :  /hook/lua/ui/game/construction.lua
#  Author(s):  Chris Blackwell / Ted Snook
#  Summary  :  Construction management UI
#  ----------------------------------------------------------
#  Modif.by :  Manimal
#  Mod.Date :  05 fvrier 2011
#  Mod.Sum. :  ADDED A FEW TESTS IN FUNCTION OnRolloverHandler FOR AVOIDING SetAlpha ERROR
#  ----------------------------------------------------------
#  Revis.by :  Manimal
#  Revision :  31 juillet 2011 -> SMALL CHANGES IN FUNCTION OnRolloverHandler
#  ----------------------------------------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

### NBR LIGNES ORIGINAL = 1949

local UnitViewDetail = import('/lua/ui/game/unitviewDetail.lua')


--[[
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF DE MANIMAL :
# ------------------
# AJOUT DE TESTS POUR VITER SI POSSIBLE L'ERREUR SUIVANTE :
# warning: Error running OnRelease script in <deleted object>: ...liance\gamedata\lua.scd\lua\ui\game\construction.lua(832): Game object has been destroyed
# 	stack traceback:
# 		[C]: in function `SetAlpha'
# 		...liance\gamedata\lua.scd\lua\ui\game\construction.lua(832): in function `OnRolloverEvent'
# 		...d alliance\gamedata\mohodata.scd\lua\maui\button.lua(131): in function <...d alliance\gamedata\mohodata.scd\lua\maui\button.lua:122>
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
]]--

function OnRolloverHandler( button, state )

	if  ( not button )  or  ( button == nil )  then  return  end
	if  ( not button.Data )  or  ( button.Data == nil )  then  return  end

	if  ( not state )  or  ( state == nil )  then  return  end
	if  ( not button.Glow )  or  ( button.Glow == nil )  then  return  end

    local item = button.Data

    if state == 'enter' then
        button.Glow:SetNeedsFrameUpdate(true)
        if item.type == 'item' then
            UnitViewDetail.Show( __blueprints[item.id], sortedOptions.selection[1], item.id )
        elseif item.type == 'enhancement' then
            UnitViewDetail.ShowEnhancement( item.enhTable, item.unitID, item.icon, GetEnhancementPrefix(item.unitID, item.icon), sortedOptions.selection[1] )
        end
    else
        button.Glow:SetNeedsFrameUpdate(false)
        button.Glow:SetAlpha(0)
        UnitViewDetail.Hide()
    end
end


