--[[####################################################################################
# File        :  /hook/lua/ui/game/unitview.lua
# Author(s)   :  Chris Blackwell
# Summary     :  Rollover unit view control
#*****************************************************************************
# Modified by :  Asdrubael -> Unit Icons + Strategic Icons ( Method Using LISTS )
# Modif. Date :  ExpWars v1 Release date
# NOTE        :  ExpWars Unit Icons must be in /icons/units/.
# -----------------------------
# Rebuilt  by :  Manimal
# Rebuilt Date:  25 janvier 2010 -> Unit + Strategic Icons ( GENERIC METHOD, NO LISTS )
# -----------------------------
# Revis.   by :  Manimal
# Revis. Date :  18 fvrier 2010 -> Added Lab + Factory Veteran Icons
# Revis. Date :  27 fvrier 2010 -> Cleaned up the script (comments, etc)
# Revis. Date :  02 mars 2010 -> Added New Unit + Strategic Icons, 
# -----------------------------
# Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
####################################################################################]]--

# ORIGINAL : 435 LIGNES

# 
#  NON DESTRUCTIVE HOOK METHOD - Scripted by Manimal.
# 

--[[
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# POUR MMOIRE :
# ~~~~~~~~~~~~~~
#INFO:   blueprintId="uel0001",
#INFO:   energyConsumed=0,
#INFO:   energyProduced=10,
#INFO:   energyRequested=0,
#INFO:   entityId="0",
#INFO:   fuelRatio=-1,
#INFO:   health=12000,
#INFO:   kills=0,
#INFO:   massConsumed=0,
#INFO:   massProduced=1,
#INFO:   massRequested=0,
#INFO:   maxHealth=12000,
#INFO:   nukeSiloBuildCount=0,
#INFO:   nukeSiloMaxStorageCount=1,
#INFO:   nukeSiloStorageCount=0,
#INFO:   shieldRatio=0,
#INFO:   tacticalSiloBuildCount=0,
#INFO:   tacticalSiloMaxStorageCount=1,
#INFO:   tacticalSiloStorageCount=0,
#INFO:   teamColor="ffe80a0a",
#INFO:   workProgress=0
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
]]--


do

--[[
]]--
	# ==================================================================================
	# AJOUT PAR MANIMAL :  MANIMAL's MOD LOCATOR
	# ==================================================================================
	local Game = import( '/lua/game.lua' )
	
	# VARIABLE ''GLOBALE'' ( par Manimal )
	local MyModPath = Game.MyModPath


	# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# CHEMIN ICONES UNITS REVIS PAR MANIMAL SELON LA STRUCTURE ACTUELLE DU MOD 
	# Icon Path Revised by Manimal According to the Current Structure of the Mod :
	local MyIconPath = MyModPath .. '/textures/ui/common/icons/units/'
	local MyStratIconPath = MyModPath ..  '/textures/ui/common/game/strategicicons/'
	# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

	local GPG_Original_UpdateWindow = UpdateWindow

	# ==================================================================================
	# FIN AJOUT PAR MANIMAL :  MANIMAL's MOD LOCATOR
	# ==================================================================================



	###########################################################################################
	# UPDATE WINDOW
	# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# NOTE DE MANIMAL :
	###########################################################################################

    function UpdateWindow( info )

		GPG_Original_UpdateWindow( info )

		if  MyModPath == nil  or  MyModPath == false
		or type( MyModPath ) != 'string'  or  string.len( MyModPath ) <= 0  then
			return
		end

		if  info.blueprintId != 'unknown'  then

			# ~~~~~~~~~~~~~
			# Units Icons :
			# ~~~~~~~~~~~~~
			if  DiskGetFileInfo( MyIconPath .. info.blueprintId .. '_icon.dds' )  then
				controls.icon:SetTexture( MyIconPath .. info.blueprintId .. '_icon.dds' )
			end

			# ~~~~~~~~~~~~~~~~
			# Strategic Icons :
			# ~~~~~~~~~~~~~~~~
			local bp = __blueprints[info.blueprintId]
			if  DiskGetFileInfo( MyStratIconPath .. bp.StrategicIconName .. '_selected.dds' )  then
				controls.stratIcon:SetTexture( MyStratIconPath .. bp.StrategicIconName .. '_selected.dds' )
			end

			# ~~~~~~~~~~~~~~~~
			# Focus Icons :
			# ~~~~~~~~~~~~~~~~
			if  info.focus  then
				if  DiskGetFileInfo( MyIconPath .. info.focus.blueprintId .. '_icon.dds' )  then
					controls.actionIcon:SetTexture( MyIconPath .. info.focus.blueprintId .. '_icon.dds' )
				end
			end

			# ~~~~~~~~~~~~~~~~~~~~
			# Kills Icons + Text :
			# ~~~~~~~~~~~~~~~~~~~~
			if  info.userUnit  and  info.kills  and  info.kills > 0  then
				if  info.userUnit:IsInCategory( 'LABO' )  or  info.userUnit:IsInCategory( 'FACTORY' )  then
					controls.statGroups[3].value:Hide()
					controls.statGroups[3].icon:Hide()
					if controls.statGroups[3].color then
						controls.statGroups[3].color:SetSolidColor( '00000000' )
					end
				else
					--# AFFICHAGE NORMAL
				end
			end


		end  --# IF

    end  --# FUNCTION

	###########################################################################################
	# FIN DE UPDATE WINDOW
	###########################################################################################




end  --DO

