do

--[[
# MODIFI PAR MANIMAL : 25 janvier 2010
   -- Unit icon must be in "/icons/units/".
   -- Put the full path to the "/icons/" folder in here, with no "/" on the end!
   --local MyIconPath = "/Mods/SoftLastAsdruMod"
# CORRIG PAR MANIMAL : 05 fvrier 2011
# ORIGINAL = 997 lignes 
]]--

	#######################################################################
	local Game = import('/lua/game.lua')
	
	#VARIABLE ''GLOBALE'' (par Manimal)
	local MyModPath = Game.MyModPath
	#######################################################################

	# =======================================================
	# NON DESTRUCTIVE NEAT HOOK METHOD - Scripted by Manimal.
	# =======================================================

	local oldUIFile = UIFile

	function UIFile( filespec )

		if  not MyModPath  or  MyModPath == nil  
		or  type( MyModPath ) != 'string'  or  string.len( MyModPath ) <= 0  then
			-- PASS OUT THE STRING SO THE ORIGINAL RESOURCE LOADER CAN DO ITS JOB ! 
			return  oldUIFile( filespec )
		end

		local skins = import('/lua/skins/skins.lua').skins
		local visitingSkin = currentSkin()

		# ORIGINAL SKIN PATH
		local currentPath = skins[visitingSkin].texturesPath  --# ex: /textures/ui/uef/

		if visitingSkin == nil or currentPath == nil then
			return nil
		end

		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# TRAITER LES SKINS DU MOD EN PREMIER.
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if visitingSkin != 'default' then -- if current skin is NOT default, then try to look for Mod's skin
			while visitingSkin do
				local curFile = MyModPath .. currentPath .. filespec
				if DiskGetFileInfo( curFile ) then
					return curFile
				else
					visitingSkin = skins[visitingSkin].default
					if visitingSkin then
						currentPath = skins[visitingSkin].texturesPath  --# ex: /textures/ui/uef/
					end
				end
			end
		end

		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# TRAITER LES SKINS ORIGINAUX ENSUITE.
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		-- PASS OUT THE STRING SO THE ORIGINAL RESOURCE LOADER CAN DO ITS JOB ! 
		return  oldUIFile( filespec )
	end

end  --DO
