--[[#######################################################################
#  File     :  /hook/lua/upgradetemplates.lua
#  Author(s):  John Comes, David Tomandl
#  Summary  :  List of all units that upgrade, and what they upgrade to.
#  -----------------------------
#  Modif.by :  Manimal
#  Modv.Date :  08 fvrier 2011 15:15 -> Ajout Units EW v2
#  -----------------------------
#  Revis.by :  xxxxxxx
#  Rev.Date :  jj mmmmm aaaa
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


UnitUpgradeTemplates =
{
    # earth unit upgrades
    {
        # LAND Engineers
        { 'uel0105', 'uel0208'},
        { 'uel0208', 'uel0309'},
        # AIR Engineers
        { 'uea0115', 'uea0215'},
        # SEA Engineers
        { 'ues0105', 'ues0208'},
    },

    # alien unit upgrades
    {
        # LAND Engineers
        { 'ual0105', 'ual0208'},
        { 'ual0208', 'ual0309'},
        # AIR Engineers
        { 'uaa0105', 'uaa0205'},
        # SEA Engineers
        { 'uas0105', 'uas0208'},
    },

    # recycler unit upgrades
    {
        # LAND Engineers
        { 'url0105', 'url0208'},
        { 'url0208', 'url0309'},
        # AIR Engineers
        { 'ura0105', 'ura0208'},
        # SEA Engineers
        { 'urs0105', 'urs0208'},

        # scout
        { 'url0101', 'urb3103'},
    },

    # seraphim unit upgrades
    {
        # LAND Engineers
        { 'xsl0105', 'xsl0208'},
        { 'xsl0208', 'xsl0309'},
        # AIR Engineers
        { 'xsa0105', 'xsa0205'},
        # SEA Engineers
        { 'xss0105', 'xss0208'},
    },
}

StructureUpgradeTemplates =
{
    # earth structure upgrades
    {
        # land factory
        { 'ueb0101', 'ueb0201'},
        { 'ueb0201', 'ueb0301'},

        # air factory
        { 'ueb0102', 'ueb0202'},
        { 'ueb0202', 'ueb0302'},

        # naval factory
        { 'ueb0103', 'ueb0203'},
        { 'ueb0203', 'ueb0303'},

        # mass extractors
        { 'ueb1103', 'ueb1202'},
        { 'ueb1202', 'ueb1302'},

        # radar
        { 'ueb3101', 'ueb3201'},
        { 'ueb3201', 'ueb3104'},

        # sonar
        { 'ueb3102', 'ueb3202'},
        { 'ueb3202', 'ues0304'},

        #Shield
        { 'ueb4202', 'ueb4301'},

    },

    # alien structure upgrades
    {
        # land factory
        { 'uab0101', 'uab0201'},
        { 'uab0201', 'uab0301'},

        # air factory
        { 'uab0102', 'uab0202'},
        { 'uab0202', 'uab0302'},

        # naval factory
        { 'uab0103', 'uab0203'},
        { 'uab0203', 'uab0303'},

        # mass extractors
        { 'uab1103', 'uab1202'},
        { 'uab1202', 'uab1302'},

        # radar
        { 'uab3101', 'uab3201'},
        { 'uab3201', 'uab3104'},

        # sonar
        { 'uab3102', 'uab3202'},
        { 'uab3202', 'uas0304'},


    },

    # recycler structure upgrades
    {
        # land factory
        { 'urb0101', 'urb0201'},
        { 'urb0201', 'urb0301'},

        # air factory
        { 'urb0102', 'urb0202'},
        { 'urb0202', 'urb0302'},

        # naval factory
        { 'urb0103', 'urb0203'},
        { 'urb0203', 'urb0303'},

        # mass extractors
        { 'urb1103', 'urb1202'},
        { 'urb1202', 'urb1302'},

        # radar
        { 'urb3101', 'urb3201'},
        { 'urb3201', 'urb3104'},

        # sonar
        { 'urb3102', 'urb3202'},
        { 'urb3202', 'urs0304'},

        # shields
        { 'urb4202', 'urb4204'},
        { 'urb4204', 'urb4205'},
        { 'urb4205', 'urb4206'},
        { 'urb4206', 'urb4207'},
    },

    # seraphim structure upgrades
    {
        # land factory
        { 'xsb0101', 'xsb0201'},
        { 'xsb0201', 'xsb0301'},

        # air factory
        { 'xsb0102', 'xsb0202'},
        { 'xsb0202', 'xsb0302'},

        # naval factory
        { 'xsb0103', 'xsb0203'},
        { 'xsb0203', 'xsb0303'},

        # mass extractors
        { 'xsb1103', 'xsb1202'},
        { 'xsb1202', 'xsb1302'},

        # radar
        { 'xsb3101', 'xsb3201'},
        { 'xsb3201', 'xsb3104'},

        # sonar
        { 'xsb3102', 'xsb3202'},
        { 'xsb3202', 'xrs0304'},

        #Shield
        { 'xsb4202', 'xsb4301'},

    },
}
