--[[#######################################################################
#  File     :  /hook/units/UEA0003/UEA0003_script.lua
#  Author(s):  GPG Devs
#  Summary  :  UEF sACU Pod Script
#  -----------------------------
#  Modif.by :  Manimal
#  Mod.Date :  11 mars 2011
#  -----------------------------
#  Revis.by :  xxxxxxx
#  Rev.Date :  jj mmmmm aaa
#  ----------------------------------------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

local TConstructionUnit = import('/lua/terranunits.lua').TConstructionUnit

UEA0003 = Class(TConstructionUnit) {
    Parent = nil,

    SetParent = function(self, parent, podName)
        self.Parent = parent
        self.Pod = podName
    end,

	# ~~~~~~~~~~~~~~~~~~~~~
	# AJOUT PAR MANIMAL :
	# ~~~~~~~~~~~~~~~~~~~~~
    OnCreate = function( self )
        TConstructionUnit.OnCreate( self )
        --# RESTRICTIONS CONCERNANT LES UNITS UNIQUES
		self:AddBuildRestriction( categories.UNIQUE + categories.LABO + categories.HEROPORTAL )
		self:RequestRefreshUI()
    end,
	# ~~~~~~~~~~~~~~~~~~~~~

    OnKilled = function(self, instigator, type, overkillRatio)
        self.Parent:NotifyOfPodDeath(self.Pod)
        self.Parent = nil
        TConstructionUnit.OnKilled(self, instigator, type, overkillRatio)
    end,

}

TypeClass = UEA0003
