#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0201/UEL0201_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Medium Tank Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local TLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TLandUnit
local TDFGaussCannonWeapon = import('/lua/terranweapons.lua').TDFGaussCannonWeapon

#####UPGRADE03
local TSAMLauncher = import('/lua/terranweapons.lua').TSAMLauncher


local Buff = import('/lua/sim/Buff.lua')
local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0201 = Class(TLandUnit) {
    Weapons = {
        MainGun = Class(TDFGaussCannonWeapon) {},
		###UPGRADE03
		UpgradeGun = Class(TDFGaussCannonWeapon) {},
		###UPGRADE04
		MissileRack01 = Class(TSAMLauncher) {},
    },

    OnCreate = function(self)
		TLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)			
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true) 
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self:HideBone('Upgrade05_02', true)
			self:HideBone('Upgrade05_03', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	

    OnStopBeingBuilt = function(self, builder, layer)
        TLandUnit.OnStopBeingBuilt(self,builder,layer)
		
		
		if self:BeenDestroyed() then return end

			self.Animator = CreateAnimator(self)
			self.Animator:SetPrecedence(0)
			self.Animator:PlayAnim(self:GetBlueprint().Display.AnimationIdle, true)
			self.Animator:SetRate( self:GetBlueprint().Display.AnimationIdleRate or 1 )
		
	        self:SetWeaponEnabledByLabel('MainGun', true)
			self:SetWeaponEnabledByLabel('UpgradeGun', false)
	        self:SetWeaponEnabledByLabel('MissileRack01', false)			
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				###Meshe
				self:ShowBone('Upgrade01_01', true)
				### DAMAGES 25%
				local wep = self:GetWeaponByLabel('MainGun')
				wep:AddDamageMod(bpEnh.GaussIDamageMod)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 28,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				####MESHE
				self:ShowBone('Upgrade02_01', true)
				#### NEW WEAPON
				self:SetWeaponEnabledByLabel('UpgradeGun', true)		
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF2',
                    DisplayName = 'UEFHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 34,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF2')
		end
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				###MESHES
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				####DAMAGES 10%
				local wep1 = self:GetWeaponByLabel('MainGun')
				wep1:AddDamageMod(bpEnh.GaussIIDamageMod)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
				wep2:AddDamageMod(bpEnh.GaussIIDamageMod)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF3',
                    DisplayName = 'UEFHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 54,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				####MESHE
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				#### NEW WEAPON
				self:SetWeaponEnabledByLabel('MissileRack01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
		BuffBlueprint {
                    Name = 'UEFHEALTHBUFF4',
                    DisplayName = 'UEFHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 61,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF4')
		end
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				### MESHE
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				self:ShowBone('Upgrade05_03', true)
				### SPEED MALUS
				self:SetSpeedMult(bp.Physics.Upgrade05SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF5',
                    DisplayName = 'UEFHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 104,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF5')
		end	
	end,
	
}

TypeClass = UEL0201
