#****************************************************************************
#**
#**  File     :  /cdimage/units/UES0304/UES0304_script.lua
#**  Author(s):  John Comes, David Tomandl
#**
#**  Summary  :  UEF Strategic Missile Submarine Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local TSubUnit = import('/lua/terranunits.lua').TSubUnit
local WeaponFile = import('/lua/terranweapons.lua')
local TIFCruiseMissileLauncherSub = WeaponFile.TIFCruiseMissileLauncherSub
local TIFStrategicMissileWeapon = WeaponFile.TIFStrategicMissileWeapon

UES0304 = Class(TSubUnit) {
    DeathThreadDestructionWaitTime = 0,
    Weapons = {
        CruiseMissiles = Class(TIFCruiseMissileLauncherSub) {
		CurrentRack = 1,
				CreateProjectileAtMuzzle = function(self, muzzle)
                    muzzle = self:GetBlueprint().RackBones[self.CurrentRack].MuzzleBones[1]
                    if self.CurrentRack >= 6 then
                        self.CurrentRack = 1
                    else
                        self.CurrentRack = self.CurrentRack + 1
                    end
                    TIFCruiseMissileLauncherSub.CreateProjectileAtMuzzle(self, muzzle)
                end,
        },
        NukeMissiles = Class(TIFStrategicMissileWeapon) {

        },
    },
}

TypeClass = UES0304

