#****************************************************************************
#**
#**  File     :  /cdimage/units/URL0104/URL0104_script.lua
#**  Author(s):  John Comes, David Tomandl
#**
#**  Summary  :  Cybran Anti-Air Tank Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local CLandUnit = import( MyModPath .. '/hook/lua/cybranunits.lua' ).CLandUnit

local CybranWeaponsFile = import('/lua/cybranweapons.lua')
local CAANanoDartWeapon = CybranWeaponsFile.CAANanoDartWeapon


local Buff = import('/lua/sim/Buff.lua')

local EffectUtil = import('/lua/EffectUtilities.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

URL0104 = Class(CLandUnit) {
    Weapons = {
        AAGun = Class(CAANanoDartWeapon) {},
		##UPGRADE03
		UpgradeGun = Class(CAANanoDartWeapon) {},
		####UPGRADE04
		UpgradeGun01 = Class(CAANanoDartWeapon) {},
		UpgradeGun02 = Class(CAANanoDartWeapon) {},
		UpgradeGun03 = Class(CAANanoDartWeapon) {},
		UpgradeGun04 = Class(CAANanoDartWeapon) {},
    },
    
    OnCreate = function(self)
        CLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)		
			##UPGRADE03
			--self:HideBone('Upgrade03_01', true)		
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true) 
			self:HideBone('Upgrade04_03', true)
			self:HideBone('Upgrade04_04', true) 
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        CLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('AAGun', true)
			self:SetWeaponEnabledByLabel('UpgradeGun', false) 
			self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
			self:SetWeaponEnabledByLabel('UpgradeGun03', false)
			self:SetWeaponEnabledByLabel('UpgradeGun04', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				##Meshes
				self:ShowBone('Upgrade01_01', true)
				### Range 10% and Rof 15%
				local wep = self:GetWeaponByLabel('AAGun')
    		    wep:ChangeRateOfFire(1.15)   
				wep:ChangeMaxRadius(35)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
    		    wep2:ChangeRateOfFire(1.15)   
				wep2:ChangeMaxRadius(35)
				
				local wep3 = self:GetWeaponByLabel('UpgradeGun01')
				wep3:ChangeMaxRadius(35)
				local wep4 = self:GetWeaponByLabel('UpgradeGun02')  
				wep4:ChangeMaxRadius(35)
				local wep5 = self:GetWeaponByLabel('UpgradeGun03')
				wep5:ChangeMaxRadius(35)
				local wep6 = self:GetWeaponByLabel('UpgradeGun04')
				wep6:ChangeMaxRadius(35)
				###SPEED 20%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF1',
                    DisplayName = 'CBRHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF1')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				##Meshes			
				self:ShowBone('Upgrade02_01', true)
				##New Weapon
				self:SetWeaponEnabledByLabel('UpgradeGun', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF2',
                    DisplayName = 'CBRHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				##Meshes
				--self:ShowBone('Upgrade03_01', true)
				--self:ShowBone('Upgrade03_02', true)
				### Range 10% and Rof 20%
				local wep = self:GetWeaponByLabel('AAGun')
    		    wep:ChangeRateOfFire(1.38)   
				wep:ChangeMaxRadius(38)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
    		    wep2:ChangeRateOfFire(1.38)   
				wep2:ChangeMaxRadius(38)
				local wep3 = self:GetWeaponByLabel('UpgradeGun01')
				wep3:ChangeMaxRadius(38)
				local wep4 = self:GetWeaponByLabel('UpgradeGun02')  
				wep4:ChangeMaxRadius(38)
				local wep5 = self:GetWeaponByLabel('UpgradeGun03')
				wep5:ChangeMaxRadius(38)
				local wep6 = self:GetWeaponByLabel('UpgradeGun04')
				wep6:ChangeMaxRadius(38)
				###SPEED 20%
				self:SetSpeedMult(1)
				self:SetSpeedMult(bp.Physics.Upgrade03SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF3',
                    DisplayName = 'CBRHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			##MESHE
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				self:ShowBone('Upgrade04_04', true)
				##IEM WEAPON
			self:SetWeaponEnabledByLabel('UpgradeGun01', true)
			self:SetWeaponEnabledByLabel('UpgradeGun02', true)
			self:SetWeaponEnabledByLabel('UpgradeGun03', true)
			self:SetWeaponEnabledByLabel('UpgradeGun04', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF4',
                    DisplayName = 'CBRHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 300,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	end,
	
	OnKilled = function(self, instigator, type, overkillRatio)
	CLandUnit.OnKilled(self, instigator, type, overkillRatio)
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if not bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			--self:Destroy()	
			end
		end			
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()		
			
			ForkThread(function()
			self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranRelife/CybranRelife_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
			
			WaitSeconds(6.5)			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)	
			self:Destroy()
			end)
			
			end
		end
		
    end,
		
	
}
TypeClass = URL0104

