#****************************************************************************
#**
#**  File     :  /cdimage/units/URL0107/URL0107_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  Cybran Heavy Infantry Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local CWalkingLandUnit = import( MyModPath .. '/hook/lua/cybranunits.lua' ).CWalkingLandUnit

local CybranWeaponsFile = import('/lua/cybranweapons.lua')
local CDFLaserHeavyWeapon = CybranWeaponsFile.CDFLaserHeavyWeapon
#local CDFRocketIridiumWeapon = CybranWeaponsFile.CDFRocketIridiumWeapon
local EffectUtil = import('/lua/EffectUtilities.lua')

#########UPGRADE04
local CAANanoDartWeapon = CybranWeaponsFile.CAANanoDartWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

URL0107 = Class(CWalkingLandUnit) {
    Weapons = {
        LaserArms = Class(CDFLaserHeavyWeapon) {},
		UpgradeGun = Class(CDFLaserHeavyWeapon) {},
################ UPGRADE04
		Upgrade04Gun01 = Class(CAANanoDartWeapon) {},		
    },
    OnCreate = function(self)
        CWalkingLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			self:HideBone('Upgrade03_03', true)
			self:HideBone('Upgrade03_04', true)
			self:HideBone('Upgrade03_05', true)			
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
        if self:GetBlueprint().General.BuildBones then
            self:SetupBuildBones()
        end
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        CWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('LaserArms', true)
			self:SetWeaponEnabledByLabel('UpgradeGun', false)
	        self:SetWeaponEnabledByLabel('Upgrade04Gun01', false)  
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,
	
    CreateBuildEffects = function( self, unitBeingBuilt, order )
       EffectUtil.SpawnBuildBots( self, unitBeingBuilt, 1, self.BuildEffectsBag )
       EffectUtil.CreateCybranBuildBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
    end,
    	
		
	#Level#	
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				##Meshes
				self:ShowBone('Upgrade01_01', true)
				### DAMAGES 10% and Rof 20%
				local wep = self:GetWeaponByLabel('LaserArms')
    		    wep:ChangeRateOfFire(bpEnh.NewRateOfFire or 3.6)   
				wep:AddDamageMod(bpEnh.LaserIDamageMod)
				###SPEED 20%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'CBRHEALTHBUFF1',
                    DisplayName = 'CBRHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF1')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				##Meshes			
				self:ShowBone('Upgrade02_01', true)
				##New Weapon
				self:SetWeaponEnabledByLabel('UpgradeGun', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF2',
                    DisplayName = 'CBRHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				##Meshes
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				self:ShowBone('Upgrade03_05', true)
				### DAMAGES 10% and Rof 15%
				local wep1 = self:GetWeaponByLabel('LaserArms')
    		    wep1:ChangeRateOfFire(bpEnh.NewRateOfFire or 4.1)   
				wep1:AddDamageMod(bpEnh.LaserIIIDamageMod)
				local wep2 = self:GetWeaponByLabel('UpgradeGun')
    		    wep2:ChangeRateOfFire(bpEnh.NewRateOfFire or 4.1)   
				wep2:AddDamageMod(bpEnh.LaserIIIDamageMod)
				###SPEED 20%
				self:SetSpeedMult(1)
				self:SetSpeedMult(bp.Physics.Upgrade03SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF3',
                    DisplayName = 'CBRHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				##MESHE
				self:ShowBone('Upgrade04_01', true)
				##IEM WEAPON
				self:SetWeaponEnabledByLabel('Upgrade04Gun01', true)
				local wep = self:GetWeaponByLabel('Upgrade04Gun01')
				wep:ChangeMaxRadius(20)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF4',
                    DisplayName = 'CBRHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'CBRHEALTHBUFF5',
                    DisplayName = 'CBRHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'CBRHEALTHBUFF5')
		end	
	end,
	
	OnKilled = function(self, instigator, type, overkillRatio)
	CWalkingLandUnit.OnKilled(self, instigator, type, overkillRatio)
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if not bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			--self:Destroy()	
			end
		end			
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
		if enh =='VeterancyV' then
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()		
			
			ForkThread(function()
			self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranRelife/CybranRelife_proj.bp', 0, 0, 0, nil, nil, nil):SetCollision(false)
			
			WaitSeconds(6.5)			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)	
			self:Destroy()
			end)
			
			end
		end
		
    end,	
	
}

TypeClass = URL0107
