#****************************************************************************
#**
#**  File     :  /cdimage/units/XAL0104/XAL0104_script.lua
#**  Author(s):  Jessica St. Croix, Gordon Duclos
#**
#**  Summary  :  Seraphim Mobile Anti-Air Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local SWalkingLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SWalkingLandUnit
local SAAShleoCannonWeapon = import('/lua/seraphimweapons.lua').SAAShleoCannonWeapon
local SAAOlarisCannonWeapon = import('/lua/seraphimweapons.lua').SAAOlarisCannonWeapon

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

local Buff = import('/lua/sim/Buff.lua')

XSL0104 = Class(SWalkingLandUnit) {
    Weapons = {
        AAGun = Class(SAAShleoCannonWeapon) {},
		######UPGRADE02
		UpgradeGun01 = Class(SAAShleoCannonWeapon) {},
		######UPGRADE04
		UpgradeGun02 = Class(SAAShleoCannonWeapon) {},
    },
	
    OnCreate = function(self)
        SWalkingLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			self:HideBone('Upgrade01_02', true)
			self:HideBone('Upgrade01_03', true)
			self:HideBone('Upgrade01_04', true)
			self:HideBone('Upgrade01_05', true)
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)					
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true) 
			self:HideBone('Upgrade03_03', true) 
			self:HideBone('Upgrade03_04', true) 
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('AAGun', true)
			self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				###MESHE
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				self:ShowBone('Upgrade01_05', true)
				###Damages 5% Range 15%
				local wep1 = self:GetWeaponByLabel('AAGun')
    		    wep1:AddDamageMod(bpEnh.AAIDamageMod) 
				wep1:ChangeMaxRadius(37)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(37)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(37)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'SRMHEALTHBUFF1',
                    DisplayName = 'SRMHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 5,
                            Mult = 1,
                        },					
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF1')
		end	
	##############################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###MESHE
				self:ShowBone('Upgrade02_01', true)		
					self:HideBone('Upgrade03_02', true)
					self:HideBone('Upgrade03_04', true)				
				###ARME ACTIVEE
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'SRMHEALTHBUFF2',
                    DisplayName = 'SRMHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 10,
                            Mult = 1,
                        },					
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF2')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				###MESHE
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				### DAMAGES 15% Range 10%
				local wep1 = self:GetWeaponByLabel('AAGun')
    		    wep1:AddDamageMod(bpEnh.AAIIIDamageMod) 
				wep1:ChangeMaxRadius(40)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(40)
				wep2:AddDamageMod(bpEnh.AAIIIDamageMod) 
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(40)	
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'SRMHEALTHBUFF3',
                    DisplayName = 'SRMHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 20,
                            Mult = 1,
                        },	
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF3')
		end				
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				###ARME ACTIVEE
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'SRMHEALTHBUFF4',
                    DisplayName = 'SRMHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 25,
                            Mult = 1,
                        },	
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF4')
		end		
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
			self:ShowBone('Upgrade05_01', true)
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade05_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				self.Trash:Add(CreateRotator(self, 'Upgrade05_01', 'y', nil, 100, 0, 100))
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'SRMHEALTHBUFF5',
                    DisplayName = 'SRMHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 40,
                            Mult = 1,
                        },
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF5')
		end	
	end,
	
}
TypeClass = XSL0104