#****************************************************************************
#**
#**  File     :  /data/units/XSL0201/XSL0201_script.lua
#**  Author(s):  Jessica St. Croix, Greg Kohne, Aaron Lundquist
#**
#**  Summary  :  Seraphim Medium Tank Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#######################################################################
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#######################################################################
local SLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SLandUnit
local SDFOhCannon = import('/lua/seraphimweapons.lua').SDFOhCannon
local SDFPhasicAutoGunWeapon = import('/lua/seraphimweapons.lua').SDFPhasicAutoGunWeapon
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSL0201 = Class(SLandUnit) {
    Weapons = {
        MainGun = Class(SDFOhCannon) {},
		###UPGRADE02
		UpgradeGun01 = Class(SDFOhCannon) {},
		###UPGRADE04
		UpgradeGun02 = Class(SDFOhCannon) {},
		UpgradeGun03 = Class(SDFOhCannon) {},
    },
	
    OnCreate = function(self)
		SLandUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			self:HideBone('Upgrade01_02', true)
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)				
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true) 
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self:HideBone('Upgrade05_02', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SLandUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('MainGun', true)
			self:SetWeaponEnabledByLabel('UpgradeGun01', false)
			self:SetWeaponEnabledByLabel('UpgradeGun02', false)
			self:SetWeaponEnabledByLabel('UpgradeGun03', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') # Ajouter 1 Trigger pour lancer Enhancement
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				###MESHE
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				###Damages 10% Range 5% et Rate Of Fire +10%
				local wep1 = self:GetWeaponByLabel('MainGun')
    		    wep1:AddDamageMod(bpEnh.SpectraIDamageMod) 
				wep1:ChangeMaxRadius(19)
				wep1:ChangeRateOfFire(bpEnh.NewRateOfFire or 0.82)
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				wep2:ChangeMaxRadius(19)
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				wep3:ChangeMaxRadius(19)
				local wep4 = self:GetWeaponByLabel('UpgradeGun03')
				wep4:ChangeMaxRadius(19)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'SRMHEALTHBUFF1',
                    DisplayName = 'SRMHEALTHBUFF1',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 10,
                            Mult = 1,
                        },					
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF1')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###MESHE
				self:ShowBone('Upgrade02_01', true)
				###ARME ACTIVEE
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'SRMHEALTHBUFF2',
                    DisplayName = 'SRMHEALTHBUFF2',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 15,
                            Mult = 1,
                        },					
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF2')
		end		
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				###MESHE
				self:ShowBone('Upgrade03_01', true)
				### DAMAGES 10% Rate Of Fire 15%
				local wep1 = self:GetWeaponByLabel('MainGun')
    		    wep1:AddDamageMod(bpEnh.SpectraIIIDamageMod) 
				wep1:ChangeRateOfFire(bpEnh.NewRateOfFire or 0.95)
				local wep2 = self:GetWeaponByLabel('MainGun')
				wep2:AddDamageMod(bpEnh.SpectraIIIDamageMod)
				wep1:ChangeRateOfFire(bpEnh.NewRateOfFire or 0.95)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'SRMHEALTHBUFF3',
                    DisplayName = 'SRMHEALTHBUFF3',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 20,
                            Mult = 1,
                        },	
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },							
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF3')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				###MESHE
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:HideBone('Turret', true)
				###WEAPONS
				self:SetWeaponEnabledByLabel('MainGun', false)
				self:SetWeaponEnabledByLabel('UpgradeGun01', false)
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				self:SetWeaponEnabledByLabel('UpgradeGun03', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'SRMHEALTHBUFF4',
                    DisplayName = 'SRMHEALTHBUFF4',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Regen = {
                            Add = 25,
                            Mult = 1,
                        },			
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },							
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF4')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade05_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				self.Trash:Add(CreateRotator(self, 'Upgrade05_01', 'z', nil, 100, 0, 100))
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            BuffBlueprint {
                    Name = 'SRMHEALTHBUFF5',
                    DisplayName = 'SRMHEALTHBUFF5',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 40,
                            Mult = 1,
                        },
						Health = {
                            Add = 150,
                            Mult = 1.0,
                        },							
                    },
                }
            end
			Buff.ApplyBuff(self, 'SRMHEALTHBUFF5')
		end	
	end,
	
}
TypeClass = XSL0201
