#****************************************************************************
#**
#**  File     :  /units/BAL0203/BAL0203_script.lua
#**
#**  Summary  :  Uef Transport Navy
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

local TConstructionEggUnit = import('/lua/terranunits.lua').TConstructionEggUnit

BAL0203 = Class(TConstructionEggUnit) {

    OnCreate = function(self)
        TConstructionEggUnit.OnCreate(self)

    end,

    OnStopBeingBuilt = function(self,builder,layer)
        TConstructionEggUnit.OnStopBeingBuilt(self,builder,layer)
        # If created with F2 on land, then play the transform anim.
        if(self:GetCurrentLayer() == 'Land') then
            self.AT1 = self:ForkThread(self.TransformThread, true)
        end
    end,

    OnMotionHorzEventChange = function(self, new, old)
        TConstructionEggUnit.OnMotionHorzEventChange(self, new, old)
        if self:IsDead() then return end
        if( not self.IsWaiting ) then
        end
    end,

    OnLayerChange = function(self, new, old)
        TConstructionEggUnit.OnLayerChange(self, new, old)
        if( old != 'None' ) then
            if( self.AT1 ) then
                self.AT1:Destroy()
                self.AT1 = nil
            end
            local myBlueprint = self:GetBlueprint()
            if( new == 'Land' ) then
				
                self.AT1 = self:ForkThread(self.TransformThread, true)
            elseif( new == 'Water' ) then
                self.AT1 = self:ForkThread(self.TransformThread, false)
            end
        end
    end,

    TransformThread = function(self, land)
        if( not self.OpenAnimManip ) then
            self.OpenAnimManip = CreateAnimator(self)
        end
        local bp = self:GetBlueprint()

        if( land ) then
			self:SetImmobile(true)
			self.OpenAnimManip = CreateAnimator(self)
			self.OpenAnimManip:PlayAnim(self:GetBlueprint().Display.AnimationOpen, false):SetRate(0.9)
			WaitSeconds(2.5)
			local bp = self:GetBlueprint()
			local buildUnit = bp.Economy.BuildUnit   
			local pos = self:GetPosition()
			local aiBrain = self:GetAIBrain()
			
			CreateUnitHPR(
				buildUnit,
				aiBrain.Name,
				pos[1], pos[2], pos[3],
				0, 0, 0
			)			
			
          WaitFor(self.OpenAnimManip)	
          self.EggSlider = CreateSlider(self, 0, 0, -5, 0, 5)
          self.Trash:Add(self.EggSlider)   
          WaitFor(self.EggSlider)     
			self:Destroy()
            self.IsWaiting = false
            self.Trash:Add(self.OpenAnimManip)
        else
            # Revert speed to maximum speed
            self.IsWaiting = true
            self.OpenAnimManip:Destroy()
            self.OpenAnimManip = nil

            self.Walking = false
        end
    end,

    EggConstruction = State {
        Main = function(self)
            local bp = self:GetBlueprint()
            local buildUnit = bp.Economy.BuildUnit
            self:GetAIBrain():BuildUnit( self, buildUnit, 1 )
        end,
    },
    
    OnStopBuild = function(self, unitBeingBuilt, order)
        if unitBeingBuilt:GetFractionComplete() == 1 then
            ForkThread(function()
                WaitSeconds(0.1)
                self:Destroy()
            end)
        end
    end,
}

TypeClass = BAL0203