--[[#######################################################################
#  File     :  /units/MAL0001/MAL0001_script.lua
#  Author(s):  John Comes, David Tomandl, Jessica St. Croix, Gordon Duclos
#  Summary  :  Special Aeon Commander Script
#  -----------------------------
#  Modif.by :  Manimal -> Veterancy Upgrades Weapons
#  Rev.Date :  dd mmmmmm 2009
#  -----------------------------
#  Modif.by :  AsdrubaelVect -> home-made cooking
#  Rev.Date :  05 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal -> Fixed up some bugs, not enough time to make Veterancy GENERIC again
#  Rev.Date :  14 juillet 2010 -> Ajout de Restrictions Oublies pour LABOS version 4b
#  Rev.Date :  26 janvier 2011 07:14 -> LABOS version 5.2 
#  Rev.Date :  07 mars 2011 01:08 -> CORRECTIONS 
#  Rev.Date :  20 mars 2011 11:16 -> MODIF KILL UNITS SI ACU MORT + CONDITION ASSASSINAT
#  Rev.Date :  22 mars 2011 00:38 -> CORRECTION OnVeteran
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


#=======================================================================
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#=======================================================================

local AWalkingLandUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).AWalkingLandUnit

local AWeapons = import('/lua/aeonweapons.lua')
local ADFDisruptorCannonWeapon = AWeapons.ADFDisruptorCannonWeapon
local AIFCommanderDeathWeapon = AWeapons.AIFCommanderDeathWeapon
local ADFOverchargeWeapon = AWeapons.ADFOverchargeWeapon
local ADFChronoDampener = AWeapons.ADFChronoDampener
local ADFGravitonProjectorWeapon = AWeapons.ADFGravitonProjectorWeapon
local ADFDisruptorCannonWeapon02 = AWeapons.ADFDisruptorCannonWeapon

local Buff = import('/lua/sim/Buff.lua')
local utilities = import('/lua/Utilities.lua')
local RandomFloat = utilities.GetRandomFloat

local AIUtils = import('/lua/ai/aiutilities.lua')
local ScenarioUtils = import('/lua/sim/ScenarioUtilities.lua')

local explosion = import('/lua/defaultexplosions.lua')
local EffectTemplate = import('/lua/EffectTemplates.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')

# ~~~~~~~~~~~~~~~~~~~
# AJOUT PAR MANIMAL :
# ~~~~~~~~~~~~~~~~~~~
--local EW_DefaultUnits = import( MyModPath .. '/hook/lua/EW_DefaultUnits.lua' ) 
--local hasHEB = false # Flag signalant Enhancement avec Heavy Electron Bolter
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF PAR ASDRUBAEL + CORRECTION PAR MANIMAL
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
--local hasHEBII = false
--local hasHEBIII = false
--local hasHEBIV = false
--local hasHEBV = false
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


MAL0001 = Class( AWalkingLandUnit ) {

    DeathThreadDestructionWaitTime = 2,

    Weapons = {
        DeathWeapon = Class(AIFCommanderDeathWeapon) {},
        RightDisruptor = Class(ADFDisruptorCannonWeapon) {},
        ChronoDampener = Class(ADFChronoDampener) {},
		VeteUpgrade1Gun = Class(ADFGravitonProjectorWeapon) {},
		VeteUpgrade2Gun = Class(ADFDisruptorCannonWeapon02) {},
        OverCharge = Class(ADFOverchargeWeapon) {

            OnCreate = function(self)
                ADFOverchargeWeapon.OnCreate(self)
                self:SetWeaponEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
				self.unit:SetOverchargePaused(false)
            end,

            OnEnableWeapon = function(self)
                if self:BeenDestroyed() then return end
                ADFOverchargeWeapon.OnEnableWeapon(self)
                self:SetWeaponEnabled(true)
                self.unit:SetWeaponEnabledByLabel('RightDisruptor', false)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(true)
                self.AimControl:SetPrecedence(20)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.AimControl:SetHeadingPitch( self.unit:GetWeaponManipulatorByLabel('RightDisruptor'):GetHeadingPitch() )
            end,

            OnWeaponFired = function(self)
                ADFOverchargeWeapon.OnWeaponFired(self)
                self:OnDisableWeapon()
                self:ForkThread(self.PauseOvercharge)
            end,
            
            OnDisableWeapon = function(self)
                if self.unit:BeenDestroyed() then return end
                self:SetWeaponEnabled(false)
                self.unit:SetWeaponEnabledByLabel('RightDisruptor', true)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                self.unit:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.AimControl:GetHeadingPitch() )
            end,
            
            PauseOvercharge = function(self)
                if not self.unit:IsOverchargePaused() then
                    self.unit:SetOverchargePaused(true)
                    WaitSeconds(1/self:GetBlueprint().RateOfFire)
                    self.unit:SetOverchargePaused(false)
                end
            end,
            
            OnFire = function(self)
                if not self.unit:IsOverchargePaused() then
                    ADFOverchargeWeapon.OnFire(self)
                end
            end,
            IdleState = State(ADFOverchargeWeapon.IdleState) {
                OnGotTarget = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ADFOverchargeWeapon.IdleState.OnGotTarget(self)
                    end
                end,            
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ChangeState(self, self.RackSalvoFiringState)
                    end
                end,
            },
            RackSalvoFireReadyState = State(ADFOverchargeWeapon.RackSalvoFireReadyState) {
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ADFOverchargeWeapon.RackSalvoFireReadyState.OnFire(self)
                    end
                end,
            },              
        },
    },


    OnCreate = function(self)
        AWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
        self:SetWeaponEnabledByLabel('ChronoDampener', false)
        self:SetupBuildBones()
        self:HideBone('Back_Upgrade', true)
        self:HideBone('Right_Upgrade', true)        
        self:HideBone('Left_Upgrade', true)  
		self:HideBone('Upgrade02_01', true)  
		# ~~~~~~~~~~~~~~~~~~~~~
		# MODIF PAR MANIMAL :
		# ~~~~~~~~~~~~~~~~~~~~~
        --# Restrict what enhancements will enable later
		self:AddBuildRestriction( categories.AEON * ( categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER ) )
		self:AddBuildRestriction( categories.AEON * ( categories.REBUILTBYCOMMANDER + categories.REBUILTBYTIER2COMMANDER + categories.REBUILTBYTIER3COMMANDER) )
		self:RequestRefreshUI()
		# ~~~~~~~~~~~~~~~~~~~~~
    end,

    OnPrepareArmToBuild = function(self)
        AWalkingLandUnit.OnPrepareArmToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(true)
        self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('RightDisruptor', false)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('RightDisruptor'):GetHeadingPitch() )
    end,

    OnStopCapture = function(self, target)
        AWalkingLandUnit.OnStopCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedCapture = function(self, target)
        AWalkingLandUnit.OnFailedCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopReclaim = function(self, target)
        AWalkingLandUnit.OnStopReclaim(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        AWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
		self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', false)		
		self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', false)	
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran')			
        self:ForkThread(self.GiveInitialResources)
    end,

    OnFailedToBuild = function(self)
        AWalkingLandUnit.OnFailedToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,
    
    OnStartBuild = function(self, unitBeingBuilt, order)
        AWalkingLandUnit.OnStartBuild(self, unitBeingBuilt, order)
        self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true     
    end,

    OnStopBuild = function(self, unitBeingBuilt)
        AWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightDisruptor', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        self:GetWeaponManipulatorByLabel('RightDisruptor'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
        self.UnitBeingBuilt = nil
        self.UnitBuildOrder = nil
        self.BuildingUnit = false          
    end,


    NukeExplosion = function(self)
        local position = self:GetPosition()
		local army = self:GetArmy()
        self:PlayUnitSound('Nuke')
			nukeProjectile = self:CreateProjectile( MyModPath .. '/hook/effects/Entities/UEFNukeEffectController01/UEFNukeEffectController01_proj.bp', 0, 0, 0, nil, nil, nil ):SetCollision(false)
            nukeProjectile:PassData(self.Data) self:ForkThread(self.CreateOuterRingWaveSmokeRing)

		local orientation = RandomFloat( 0, 2 * math.pi )
    end,

    CreateFirePlumes = function( self, army, bones, yBoneOffset )
        local proj, position, offset, velocity
        local basePosition = self:GetPosition()
        for k, vBone in bones do
            position = self:GetPosition(vBone)
            offset = utilities.GetDifferenceVector( position, basePosition )
            velocity = utilities.GetDirectionVector( position, basePosition ) # 
            velocity.x = velocity.x + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.z = velocity.z + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.y = velocity.y + utilities.GetRandomFloat( 9, 0.3)
            proj = self:CreateProjectile('/effects/entities/DestructionFirePlume01/DestructionFirePlume01_proj.bp', offset.x, offset.y + yBoneOffset, offset.z, velocity.x, velocity.y, velocity.z)
            proj:SetBallisticAcceleration(utilities.GetRandomFloat(-4, -6)):SetVelocity(utilities.GetRandomFloat(9, 11)):SetCollision(false)
            
            local emitter = CreateEmitterOnEntity(proj, army, '/effects/emitters/destruction_explosion_fire_plume_03_emit.bp'):ScaleEmitter(0.5)

            local lifetime = utilities.GetRandomFloat( 20, 32 )
        end
    end,	

    CreateExplosionDebris = function( self, army )
        for k, v in EffectTemplate.ExplosionDebrisLrg01 do
            CreateAttachedEmitter( self, 'Torso', army, v )
        end
    end,	


	DeathThread = function(self)

		local army = self:GetArmy()

		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		--# MODIF PAR MANIMAL :
		--# retour aux conditions de victoire demandes en conservant les kills du mod
		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if ScenarioInfo.Options.Victory == 'demoralization' then
			--# ALL UNITS are dead if you have no Commanders
			local units = ArmyBrains[army]:GetListOfUnits( categories.ALLUNITS, false )
			for index,unit in units do
				unit:Kill()
			end
		end

		self:CreateFirePlumes( army, {'Torso','Torso','Head','Torso','Head','Torso', 'Torso', 'Head', 'Head', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 4.0 )
		self:PlayUnitSound('Killed2')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()}) 
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )		
        self:ShakeCamera(50, 5, 0, 1)
        for k, v in EffectTemplate.FootFall01 do
            CreateAttachedEmitter(self,'Torso',army, v):ScaleEmitter(2)          
            CreateAttachedEmitter(self,'Torso',army, v):ScaleEmitter(2) 
        end		
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )       
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})           
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:PlayUnitSound('Killed')
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.5 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.5 )
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )				
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})    
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed2')
		self:CreateFirePlumes( army, {'Left_Turret','Left_Turret','Head','Torso','Head','Right_Turret_Barrel', 'Right_Turret_Barrel', 'Left_Arm_B02', 'Right_Arm_B02', }, 0.2 )			
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})   
		self:PlayUnitSound('Killed2')        
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Arm_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'UAL0001', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 0.1 )     		
		if self.DeathAnimManip then
			WaitFor(self.DeathAnimManip)
		end
		self:NukeExplosion()
		WaitSeconds(2)
		self:Destroy()
	end, 	


    GiveInitialResources = function(self)
        WaitTicks(2)
        self:GetAIBrain():GiveResource('Energy', self:GetBlueprint().Economy.StorageEnergy)
        self:GetAIBrain():GiveResource('Mass', self:GetBlueprint().Economy.StorageMass)
    end,
    
    CreateBuildEffects = function( self, unitBeingBuilt, order )
        EffectUtil.CreateAeonCommanderBuildingEffects( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
    end,  

    PlayCommanderWarpInEffect = function(self)
        self:HideBone(0, true)
        self:SetUnSelectable(true)
        self:SetBusy(true)
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
    end,

    WarpInEffectThread = function(self)
        self:PlayUnitSound('CommanderArrival')
        self:CreateProjectile( '/effects/entities/UnitTeleport01/UnitTeleport01_proj.bp', 0, 1.35, 0, nil, nil, nil):SetCollision(false)
        WaitSeconds(2.1)
        self:SetMesh( MyModPath .. '/units/MAL0001/MAL0001_PhaseShield2_mesh', true)
        self:ShowBone(0, true)
        self:SetUnSelectable(false)
        self:SetBusy(false)        
        self:SetBlockCommandQueue(false)
        self:HideBone('Back_Upgrade', true)
        self:HideBone('Right_Upgrade', true)        
        self:HideBone('Left_Upgrade', true)
		self:HideBone('Upgrade02_01', true)		
        local totalBones = self:GetBoneCount() - 1
        local army = self:GetArmy()
        for k, v in EffectTemplate.UnitTeleportSteam01 do
            for bone = 1, totalBones do
                CreateAttachedEmitter(self,bone,army, v)
            end
        end

        WaitSeconds(6)
        self:SetMesh(self:GetBlueprint().Display.MeshBlueprint, true)
    end,


    CreateHeavyShield = function(self, bp)
        WaitTicks(1)
        self:CreatePersonalShield(bp)
        self:SetEnergyMaintenanceConsumptionOverride(bp.MaintenanceConsumptionPerSecondEnergy or 0)
        self:SetMaintenanceConsumptionActive()
    end,
    
    OnPaused = function(self)
        AWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            AWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end    
    end,
    
    OnUnpaused = function(self)
        if self.BuildingUnit then
            AWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        AWalkingLandUnit.OnUnpaused(self)
    end,     


	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				--self:ShowBone('VeteUpgradePart0101', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 100,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################

        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 120,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end
	##################################
	end,



	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# TOUTES LES AMLIORATIONS UBC
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    CreateEnhancement = function(self, enh)
        AWalkingLandUnit.CreateEnhancement(self, enh)
        local bpEnh = self:GetBlueprint().Enhancements[enh]
        if not bpEnh then return end

        #Resource Allocation
        if enh == 'ResourceAllocation' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationAdvanced' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationAdvancedRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
        #Shields
        elseif enh == 'Shield' then
            self:AddToggleCap('RULEUTC_ShieldToggle')
            self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
            self:SetMaintenanceConsumptionActive()
            self:CreatePersonalShield(bpEnh)
        elseif enh == 'ShieldRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle')
        elseif enh == 'ShieldHeavy' then
            self:AddToggleCap('RULEUTC_ShieldToggle')
            self:ForkThread(self.CreateHeavyShield, bpEnh)
        elseif enh == 'ShieldHeavyRemove' then
            self:DestroyShield()
            self:SetMaintenanceConsumptionInactive()
            self:RemoveToggleCap('RULEUTC_ShieldToggle')
        #Teleporter
        elseif enh == 'Teleporter' then
            self:AddCommandCap('RULEUCC_Teleport')
        elseif enh == 'TeleporterRemove' then
            self:RemoveCommandCap('RULEUCC_Teleport')
        #Chrono Dampener
        elseif enh == 'ChronoDampener' then
            self:SetWeaponEnabledByLabel('ChronoDampener', true)
        elseif enh == 'ChronoDampenerRemove' then
            self:SetWeaponEnabledByLabel('ChronoDampener', false)

		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# GESTION DES BuildRestrictions : GARE AUX PERTES DE MODIFS !
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        #T2 Engineering
        elseif enh =='AdvancedEngineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()


            if not Buffs['AeonACUT2BuildRate'] then
                BuffBlueprint {
                    Name = 'AeonACUT2BuildRate',
                    DisplayName = 'AeonACUT2BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'AeonACUT2BuildRate')


        elseif enh =='AdvancedEngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'AeonACUT2BuildRate' ) then
                Buff.RemoveBuff( self, 'AeonACUT2BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.AEON * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then
				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then
					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end
					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end
				end
			end


        #T3 Engineering
        elseif enh =='T3Engineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()

            if not Buffs['AeonACUT3BuildRate'] then
                BuffBlueprint {
                    Name = 'AeonACUT3BuildRate',
                    DisplayName = 'AeonCUT3BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'AeonACUT3BuildRate')


        elseif enh =='T3EngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'AeonACUT3BuildRate' ) then
                Buff.RemoveBuff( self, 'AeonACUT3BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.AEON * ( categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			--# Suppression de 'T3Engineering'
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then

				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then

					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end

					--# Suppression de 'AdvancedEngineering'
					preReq = bpPreReq.Prerequisite
					if  preReq  and  preReq != nil  then
						bpPreReq = self:GetBlueprint().Enhancements[preReq]
						if  bpPreReq  and  bpPreReq != nil  then
							cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
							if  cat  and  cat != nil  then
								self:AddBuildRestriction( cat )
								self:RequestRefreshUI()
							end
						end  --# END  IF  bpPreReq  T2
					end  --# END  IF  preReq  T2

					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end

				end  --# END  IF  bpPreReq  T3
			end  --# END  IF  preReq  T3


		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# FIN DE GESTION DES BuildRestrictions - SCRIPT de MANIMAL
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


        #Crysalis Beam
        elseif enh == 'CrysalisBeam' then
            local wep = self:GetWeaponByLabel('RightDisruptor')
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
            wep:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
			wep2:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
            wep3:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
        elseif enh == 'CrysalisBeamRemove' then
            local wep = self:GetWeaponByLabel('RightDisruptor')
            local bpDisrupt = self:GetBlueprint().Weapon[1].MaxRadius
            wep:ChangeMaxRadius(bpDisrupt or 22)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpDisrupt or 22)
        #Heat Sink Augmentation
        elseif enh == 'HeatSink' then
            local wep = self:GetWeaponByLabel('RightDisruptor')
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
            wep:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
			wep2:ChangeRateOfFire(bpEnh.NewRateOfFireII or 3)
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
            wep3:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
        elseif enh == 'HeatSinkRemove' then
            local wep = self:GetWeaponByLabel('RightDisruptor')
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
            local bpDisrupt = self:GetBlueprint().Weapon[1].RateOfFire
            wep:ChangeRateOfFire(bpDisrupt or 1)
			wep2:ChangeRateOfFire(bpDisrupt or 2)
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
			wep3:ChangeRateOfFire(bpDisrupt or 1)
        #Enhanced Sensor Systems
        elseif enh == 'EnhancedSensors' then
            self:SetIntelRadius('Vision', bpEnh.NewVisionRadius or 104)
            self:SetIntelRadius('Omni', bpEnh.NewOmniRadius or 104)
        elseif enh == 'EnhancedSensorsRemove' then
            local bpIntel = self:GetBlueprint().Intel
            self:SetIntelRadius('Vision', bpIntel.VisionRadius or 26)
            self:SetIntelRadius('Omni', bpIntel.OmniRadius or 26)
        end
    end,

}

TypeClass = MAL0001
