--[[#######################################################################
#
#  File     :  /units/MRL0001/MRL0001_script.lua
#  Author(s):  John Comes, David Tomandl, Jessica St. Croix, Gordon Duclos, Andres Mendez
#  Summary  :  Cybran Commander Unit Script
#  -----------------------------
#  Modif by :  Asdrubaelvect
#  Rev.Date :  19 septembre 2009
#  -----------------------------
#  Modif by :  Manimal -> Fixed up some bugs, not enough time to make Veterancy GENERIC again
#  Rev.Date :  24 fvrier 2010
#  Rev.Date :  27 mai 2010
#  Rev.Date :  14 juillet 2010 -> Ajout de Restrictions Oublies pour LABOS version 4b
#  Rev.Date :  26 janvier 2011 07:15 -> LABOS version 5.2 
#  Rev.Date :  07 mars 2011 01:08 -> CORRECTIONS 
#  Rev.Date :  20 mars 2011 11:16 -> MODIF KILL UNITS SI ACU MORT + CONDITION ASSASSINAT
#  Rev.Date :  22 mars 2011 00:38 -> CORRECTION OnVeteran
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

# ==============================================================================================
# MODIFS FAITES PAR MANIMAL :
# VOIR LIGNES 92, 110, 174, 185, 196, 207, 239, 257 :
# => SetHead01ingPitch ET GetHead01ingPitch REMPLACS PAR SetHeadingPitch ET GetHeadingPitch
# ==============================================================================================

#=======================================================================
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#=======================================================================



local CWalkingLandUnit = import( MyModPath .. '/hook/lua/cybranunits.lua' ).CWalkingLandUnit
local CWeapons = import('/lua/cybranweapons.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

local utilities = import('/lua/Utilities.lua')
local RandomFloat = utilities.GetRandomFloat
local explosion = import('/lua/defaultexplosions.lua')

#local CAAMissileNaniteWeapon = CWeapons.CAAMissileNaniteWeapon
local CCannonMolecularWeapon = CWeapons.CCannonMolecularWeapon
local CIFCommanderDeathWeapon = CWeapons.CIFCommanderDeathWeapon
local EffectTemplate = import('/lua/EffectTemplates.lua')
local CDFHeavyMicrowaveLaserGeneratorCom = CWeapons.CDFHeavyMicrowaveLaserGeneratorCom
local CDFOverchargeWeapon = CWeapons.CDFOverchargeWeapon
local CANTorpedoLauncherWeapon = CWeapons.CANTorpedoLauncherWeapon
local Entity = import('/lua/sim/Entity.lua').Entity

local CCannonMolecularWeapon02 = CWeapons.CCannonMolecularWeapon
local CCannonMolecularWeapon03 = CWeapons.CCannonMolecularWeapon

# ~~~~~~~~~~~~~~~~~~~
# AJOUT PAR MANIMAL :
# ~~~~~~~~~~~~~~~~~~~
--local EW_DefaultUnits = import( MyModPath .. '/hook/lua/EW_DefaultUnits.lua' ) 
--local hasHEB = false # Flag signalant Enhancement avec Heavy Electron Bolter
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# MODIF PAR ASDRUBAEL + CORRECTION PAR MANIMAL
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
--local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
--local hasHEBII = false
--local hasHEBIII = false
--local hasHEBIV = false
--local hasHEBV = false
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


MRL0001 = Class( CWalkingLandUnit ) {
    DeathThreadDestructionWaitTime = 2,

    Weapons = {
        DeathWeapon = Class(CIFCommanderDeathWeapon) {},
        RightRipper = Class(CCannonMolecularWeapon) {},
        Torpedo = Class(CANTorpedoLauncherWeapon) {},
        MLG = Class(CDFHeavyMicrowaveLaserGeneratorCom) {
            DisabledFiringBones = {'Turret_Muzzle_03'},
            
            SetOnTransport = function(self, transportstate)
                CDFHeavyMicrowaveLaserGeneratorCom.SetOnTransport(self, transportstate)
                self:ForkThread(self.OnTransportWatch)
            end,
            
            OnTransportWatch = function(self)
                while self:GetOnTransport() do
                    self:PlayFxBeamEnd()
                    self:SetWeaponEnabled(false)
                    WaitSeconds(0.3)
                end
            end,          
        },

        OverCharge = Class(CDFOverchargeWeapon) {
            OnCreate = function(self)
                CDFOverchargeWeapon.OnCreate(self)
                self:SetWeaponEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
				self.unit:SetOverchargePaused(false)
            end,

            OnEnableWeapon = function(self)
                if self:BeenDestroyed() then return end
                CDFOverchargeWeapon.OnEnableWeapon(self)
                self:SetWeaponEnabled(true)
                self.unit:SetWeaponEnabledByLabel('RightRipper', false)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(true)
                self.AimControl:SetPrecedence(20)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                #self.AimControl:SetHead01ingPitch( self.unit:GetWeaponManipulatorByLabel('RightRipper'):GetHead01ingPitch() )
                self.AimControl:SetHeadingPitch( self.unit:GetWeaponManipulatorByLabel('RightRipper'):GetHeadingPitch() )
            end,

            OnWeaponFired = function(self)
                CDFOverchargeWeapon.OnWeaponFired(self)
                self:OnDisableWeapon()
                self:ForkThread(self.PauseOvercharge)
            end,
            
            OnDisableWeapon = function(self)
                if self.unit:BeenDestroyed() then return end
                self:SetWeaponEnabled(false)
                self.unit:SetWeaponEnabledByLabel('RightRipper', true)
                self.unit:BuildManipulatorSetEnabled(false)
                self.AimControl:SetEnabled(false)
                self.AimControl:SetPrecedence(0)
                self.unit.BuildArmManipulator:SetPrecedence(0)
                #self.unit:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.AimControl:GetHead01ingPitch() )
                self.unit:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.AimControl:GetHeadingPitch() )
            end,
            
            PauseOvercharge = function(self)
                if not self.unit:IsOverchargePaused() then
                    self.unit:SetOverchargePaused(true)
                    WaitSeconds(1/self:GetBlueprint().RateOfFire)
                    self.unit:SetOverchargePaused(false)
                end
            end,
            
            OnFire = function(self)
                if not self.unit:IsOverchargePaused() then
                    CDFOverchargeWeapon.OnFire(self)
                end
            end,
            IdleState = State(CDFOverchargeWeapon.IdleState) {
                OnGotTarget = function(self)
                    if not self.unit:IsOverchargePaused() then
                        CDFOverchargeWeapon.IdleState.OnGotTarget(self)
                    end
                end,            
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        ChangeState(self, self.RackSalvoFiringState)
                    end
                end,
            },
            RackSalvoFireReadyState = State(CDFOverchargeWeapon.RackSalvoFireReadyState) {
                OnFire = function(self)
                    if not self.unit:IsOverchargePaused() then
                        CDFOverchargeWeapon.RackSalvoFireReadyState.OnFire(self)
                    end
                end,
            },    
        },
        VeteUpgrade1Gun = Class(CCannonMolecularWeapon02) {},		
		VeteUpgrade2Gun = Class(CCannonMolecularWeapon03) {},
    },

    # ********
    # Creation
    # ********
    OnCreate = function(self)
        CWalkingLandUnit.OnCreate(self)
        self:SetCapturable(false)
        self:HideBone('Back_Upgrade01', true)
        self:HideBone('Right_Upgrade', true)
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
        if self:GetBlueprint().General.BuildBones then
            self:SetupBuildBones()
        end
        # Restrict what enhancements will enable later
        self:AddBuildRestriction( categories.CYBRAN * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )
		# ~~~~~~~~~~~~~~~~~~~~~
		# AJOUT PAR MANIMAL :
		# ~~~~~~~~~~~~~~~~~~~~~
		self:AddBuildRestriction( categories.CYBRAN * (categories.REBUILTBYCOMMANDER + categories.REBUILTBYTIER2COMMANDER + categories.REBUILTBYTIER3COMMANDER) )
		# ~~~~~~~~~~~~~~~~~~~~~
    end,


    OnPrepareArmToBuild = function(self)
        CWalkingLandUnit.OnPrepareArmToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(true)
        self.BuildArmManipulator:SetPrecedence(20)
        self:SetWeaponEnabledByLabel('RightRipper', false)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self.BuildArmManipulator:SetHead01ingPitch( self:GetWeaponManipulatorByLabel('RightRipper'):GetHead01ingPitch() )
        self.BuildArmManipulator:SetHeadingPitch( self:GetWeaponManipulatorByLabel('RightRipper'):GetHeadingPitch() )
    end,

    OnStopCapture = function(self, target)
        CWalkingLandUnit.OnStopCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.BuildArmManipulator:GetHead01ingPitch() )
        self:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnFailedCapture = function(self, target)
        CWalkingLandUnit.OnFailedCapture(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.BuildArmManipulator:GetHead01ingPitch() )
        self:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopReclaim = function(self, target)
        CWalkingLandUnit.OnStopReclaim(self, target)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.BuildArmManipulator:GetHead01ingPitch() )
        self:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStopBeingBuilt = function(self,builder,layer)
        CWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('MLG', false)
        self:SetWeaponEnabledByLabel('Torpedo', false)
        self:SetMaintenanceConsumptionInactive()
        self:DisableUnitIntel('RadarStealth')
        self:DisableUnitIntel('SonarStealth')
        self:DisableUnitIntel('Cloak')
        self:DisableUnitIntel('Sonar')
        self:HideBone('Back_Upgrade01', true)
        self:HideBone('Right_Upgrade', true)
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
		###VETE WPN I####
		self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', false)
		###VETE WPN II####
		self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', false)
		###VETE###
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran')	
		###VETE###			
        self:ForkThread(self.GiveInitialResources)
    end,

    OnFailedToBuild = function(self)
        CWalkingLandUnit.OnFailedToBuild(self)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.BuildArmManipulator:GetHead01ingPitch() )
        self:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
    end,

    OnStartBuild = function(self, unitBeingBuilt, order)    
        CWalkingLandUnit.OnStartBuild(self, unitBeingBuilt, order)
        self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true        
    end,    

    OnStopBuild = function(self, unitBeingBuilt)
        CWalkingLandUnit.OnStopBuild(self, unitBeingBuilt)
        if self:BeenDestroyed() then return end
        self:BuildManipulatorSetEnabled(false)
        self.BuildArmManipulator:SetPrecedence(0)
        self:SetWeaponEnabledByLabel('RightRipper', true)
        self:SetWeaponEnabledByLabel('OverCharge', false)
        #self:GetWeaponManipulatorByLabel('RightRipper'):SetHead01ingPitch( self.BuildArmManipulator:GetHead01ingPitch() )
        self:GetWeaponManipulatorByLabel('RightRipper'):SetHeadingPitch( self.BuildArmManipulator:GetHeadingPitch() )
        self.UnitBeingBuilt = nil
        self.UnitBuildOrder = nil
        self.BuildingUnit = false          
    end,


    NukeExplosion = function(self)
        local position = self:GetPosition()
		local army = self:GetArmy()
        self:PlayUnitSound('Nuke')
			nukeProjectile = self:CreateProjectile( MyModPath .. '/hook/effects/Entities/UEFNukeEffectController01/UEFNukeEffectController01_proj.bp', 0, 0, 0, nil, nil, nil ):SetCollision(false)
            nukeProjectile:PassData(self.Data) self:ForkThread(self.CreateOuterRingWaveSmokeRing)

		local orientation = RandomFloat( 0, 2 * math.pi )
    end,

    CreateFirePlumes = function( self, army, bones, yBoneOffset )
        local proj, position, offset, velocity
        local basePosition = self:GetPosition()
        for k, vBone in bones do
            position = self:GetPosition(vBone)
            offset = utilities.GetDifferenceVector( position, basePosition )
            velocity = utilities.GetDirectionVector( position, basePosition ) # 
            velocity.x = velocity.x + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.z = velocity.z + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.y = velocity.y + utilities.GetRandomFloat( 9, 0.3)
            proj = self:CreateProjectile('/effects/entities/DestructionFirePlume01/DestructionFirePlume01_proj.bp', offset.x, offset.y + yBoneOffset, offset.z, velocity.x, velocity.y, velocity.z)
            proj:SetBallisticAcceleration(utilities.GetRandomFloat(-4, -6)):SetVelocity(utilities.GetRandomFloat(9, 11)):SetCollision(false)
            
            local emitter = CreateEmitterOnEntity(proj, army, '/effects/emitters/destruction_explosion_fire_plume_03_emit.bp'):ScaleEmitter(0.5)

            local lifetime = utilities.GetRandomFloat( 20, 32 )
        end
    end,	

    CreateExplosionDebris = function( self, army )
        for k, v in EffectTemplate.ExplosionDebrisLrg01 do
            CreateAttachedEmitter( self, 'Torso01', army, v )
        end
    end,	


	DeathThread = function(self)

		local army = self:GetArmy()

		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		--# MODIF PAR MANIMAL :
		--# retour aux conditions de victoire demandes en conservant les kills du mod
		--# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if ScenarioInfo.Options.Victory == 'demoralization' then
			--# ALL UNITS are dead if you have no Commanders
			local units = ArmyBrains[army]:GetListOfUnits( categories.ALLUNITS, false )
			for index,unit in units do
				unit:Kill()
			end
		end

		self:CreateFirePlumes( army, {'Torso01','Torso01','Head01','Torso01','Head01','Torso01', 'Torso01', 'Head01', 'Head01', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 4.0 )
		self:PlayUnitSound('Killed2')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()}) 
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg03_B02', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )				
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
        self:CreateExplosionDebris( army )
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )		
        self:ShakeCamera(50, 5, 0, 1)
        for k, v in EffectTemplate.FootFall01 do
            CreateAttachedEmitter(self,'Torso01',army, v):ScaleEmitter(2)          
            CreateAttachedEmitter(self,'Torso01',army, v):ScaleEmitter(2) 
        end		
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.2 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.7 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg01_B03', 0.2 )
		self:PlayUnitSound('Killed')
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.5 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.5 )       
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})           
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg03_B02', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.7 )
		self:PlayUnitSound('Killed')
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )				
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.5 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg01_B03', 0.5 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.5 )
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )				
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.5 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.5 )
		self:PlayUnitSound('Killed')
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})    
		self:PlayUnitSound('Killed')		
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.1 )
		self:PlayUnitSound('Killed2')
		self:CreateFirePlumes( army, {'Left_Leg01_B03','Right_Leg01_B03','Head01','Torso01','Head01','Right_Leg02_B01', 'Left_Leg02_B01', 'Right_Turret', 'Left_Turret', }, 0.2 )			
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg01_B03', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.1 )     
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.1 )
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})   
		self:PlayUnitSound('Killed2')        
        WaitSeconds(2)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Turret', 0.1 )
		self:PlayUnitSound('Killed')
        WaitSeconds(0.3)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Left_Leg01_B03', 0.1 )
        explosion.CreateDefaultHitExplosionAtBone( self, 'Right_Leg03_B02', 0.1 )
		self:PlayUnitSound('Killed2')
        WaitSeconds(0.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso01', 0.1 )     		
		if self.DeathAnimManip then
			WaitFor(self.DeathAnimManip)
		end
		self:NukeExplosion()
		WaitSeconds(2)
		self:Destroy()
	end, 


    PlayCommanderWarpInEffect = function(self)
        self:HideBone(0, true)
        self:SetUnSelectable(true)
        self:SetBusy(true)        
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
    end,

    WarpInEffectThread = function(self)
        self:PlayUnitSound('CommanderArrival')
        self:CreateProjectile( MyModPath .. '/hook/effects/entities/CybranUnitTeleport01/CybranUnitTeleport01_proj.bp', 0, 1.35, 0, nil, nil, nil):SetCollision(false)
        WaitSeconds(2.1)
        self:SetMesh( MyModPath .. '/units/MRL0001/MRL0001_PhaseShield_mesh', true)

        self:ShowBone(0, true)
        self:HideBone('Back_Upgrade01', true)
        self:HideBone('Right_Upgrade', true)
		self:HideBone('VeteUpgradePart0101', true)
		self:HideBone('VeteUpgradePart0201', true)
        self:SetUnSelectable(false)
        self:SetBusy(false)        
        self:SetBlockCommandQueue(false)

        local totalBones = self:GetBoneCount() - 1
        local army = self:GetArmy()
        for k, v in EffectTemplate.UnitTeleportSteam01 do
            for bone = 1, totalBones do
                CreateAttachedEmitter(self,bone,army, v)
            end
        end
        
        WaitSeconds(6)
        self:SetMesh(self:GetBlueprint().Display.MeshBlueprint, true)
    end,    

    GiveInitialResources = function(self)
        WaitTicks(2)
        self:GetAIBrain():GiveResource('Energy', self:GetBlueprint().Economy.StorageEnergy)
        self:GetAIBrain():GiveResource('Mass', self:GetBlueprint().Economy.StorageMass)
    end,
    


    OnScriptBitSet = function(self, bit)
        if bit == 8 then # cloak toggle
            self:StopUnitAmbientSound( 'ActiveLoop' )
            self:SetMaintenanceConsumptionInactive()
            self:DisableUnitIntel('Cloak')
            self:DisableUnitIntel('RadarStealth')
            self:DisableUnitIntel('RadarStealthField')
            self:DisableUnitIntel('SonarStealth')
            self:DisableUnitIntel('SonarStealthField')          
        end
    end,

    OnScriptBitClear = function(self, bit)
        if bit == 8 then # cloak toggle
            self:PlayUnitAmbientSound( 'ActiveLoop' )
            self:SetMaintenanceConsumptionActive()
            self:EnableUnitIntel('Cloak')
            self:EnableUnitIntel('RadarStealth')
            self:EnableUnitIntel('RadarStealthField')
            self:EnableUnitIntel('SonarStealth')
            self:EnableUnitIntel('SonarStealthField')
        end
    end,

    

    # *************
    # Build/Upgrade
    # *************
    CreateBuildEffects = function( self, unitBeingBuilt, order )
       EffectUtil.SpawnBuildBots( self, unitBeingBuilt, 5, self.BuildEffectsBag )
       EffectUtil.CreateCybranBuildBeams( self, unitBeingBuilt, self:GetBlueprint().General.BuildBones.BuildEffectBones, self.BuildEffectsBag )
    end,


    # **********
    # Intel
    # **********    
    IntelEffects = {
		Cloak = {
		    {
			    Bones = {
				    'Head01',
				    'Right_Turret',
				    'Left_Turret',
				    'Left_Leg01_B03',
				    'Left_Arm_B01',
				    'Chest_Right01',
				    'Chest_Left01',
					'Torso01',
			    },
			    Scale = 1.0,
			    Type = 'Cloak01',
		    },
		},
		Field = {
		    {
			    Bones = {
				    'Head01',
				    'Right_Turret',
				    'Left_Turret',
				    'Left_Leg01_B03',
				    'Left_Arm_B01',
				    'Chest_Right01',
				    'Chest_Left01',
		            'Torso01',
			    },
			    Scale = 1.6,
			    Type = 'Cloak01',
		    },	
        },	
    },
    
    OnIntelEnabled = function(self)
        CWalkingLandUnit.OnIntelEnabled(self)
        if self.CloakEnh and self:IsIntelEnabled('Cloak') then 
            self:SetEnergyMaintenanceConsumptionOverride(self:GetBlueprint().Enhancements['CloakingGenerator'].MaintenanceConsumptionPerSecondEnergy or 0)
            self:SetMaintenanceConsumptionActive()
            if not self.IntelEffectsBag then
			    self.IntelEffectsBag = {}
			    self.CreateTerrainTypeEffects( self, self.IntelEffects.Cloak, 'FXIdle',  self:GetCurrentLayer(), nil, self.IntelEffectsBag )
			end            
        elseif self.StealthEnh and self:IsIntelEnabled('RadarStealth') and self:IsIntelEnabled('SonarStealth') then
            self:SetEnergyMaintenanceConsumptionOverride(self:GetBlueprint().Enhancements['StealthGenerator'].MaintenanceConsumptionPerSecondEnergy or 0)
            self:SetMaintenanceConsumptionActive()  
            if not self.IntelEffectsBag then 
	            self.IntelEffectsBag = {}
		        self.CreateTerrainTypeEffects( self, self.IntelEffects.Field, 'FXIdle',  self:GetCurrentLayer(), nil, self.IntelEffectsBag )
		    end                  
        end		
    end,

    OnIntelDisabled = function(self)
        CWalkingLandUnit.OnIntelDisabled(self)
        if self.IntelEffectsBag then
            EffectUtil.CleanupEffectBag(self,'IntelEffectsBag')
            self.IntelEffectsBag = nil
        end
        if self.CloakEnh and not self:IsIntelEnabled('Cloak') then
            self:SetMaintenanceConsumptionInactive()
        elseif self.StealthEnh and not self:IsIntelEnabled('RadarStealth') and not self:IsIntelEnabled('SonarStealth') then
            self:SetMaintenanceConsumptionInactive()
        end          
    end,
        
    # *****
    # Death
    # *****
    OnKilled = function(self, instigator, type, overkillRatio)
        local bp
        for k, v in self:GetBlueprint().Buffs do
            if v.Add.OnDeath then
                bp = v
            end
        end 
        --#if we could find a blueprint with v.Add.OnDeath, then add the buff 
        if bp != nil then 
            #Apply Buff
			self:AddBuff(bp)
        end
        --#otherwise, we should finish killing the unit
        CWalkingLandUnit.OnKilled(self, instigator, type, overkillRatio)
    end,
    
    OnPaused = function(self)
        CWalkingLandUnit.OnPaused(self)
        if self.BuildingUnit then
            CWalkingLandUnit.StopBuildingEffects(self, self:GetUnitBeingBuilt())
        end    
    end,
    
    OnUnpaused = function(self)
        if self.BuildingUnit then
            CWalkingLandUnit.StartBuildingEffects(self, self:GetUnitBeingBuilt(), self.UnitBuildOrder)
        end
        CWalkingLandUnit.OnUnpaused(self)
    end,     


	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('VeteUpgradePart0101', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade1Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 110,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bp.NewRegenRate,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('VeteUpgradePart0201', true)
				self:SetWeaponEnabledByLabel('VeteUpgrade2Gun', true)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 120,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = 1,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
	end,

	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	# TOUTES LES AMLIORATIONS UBC
	#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    CreateEnhancement = function( self, enh )

        CWalkingLandUnit.CreateEnhancement(self, enh)

        local bpEnh = self:GetBlueprint().Enhancements[enh]
        if not bpEnh then return end

        if enh == 'Teleporter' then
            self:AddCommandCap('RULEUCC_Teleport')
        elseif enh == 'TeleporterRemove' then
            RemoveUnitEnhancement(self, 'Teleporter')
            RemoveUnitEnhancement(self, 'TeleporterRemove')
            self:RemoveCommandCap('RULEUCC_Teleport')
        elseif enh == 'StealthGenerator' then
            self:AddToggleCap('RULEUTC_CloakToggle')
            if self.IntelEffectsBag then
                EffectUtil.CleanupEffectBag(self,'IntelEffectsBag')
                self.IntelEffectsBag = nil
            end
            self.CloakEnh = false        
            self.StealthEnh = true
            self:EnableUnitIntel('RadarStealth')
            self:EnableUnitIntel('SonarStealth')
        elseif enh == 'StealthGeneratorRemove' then
            self:RemoveToggleCap('RULEUTC_CloakToggle')
            self:DisableUnitIntel('RadarStealth')
            self:DisableUnitIntel('SonarStealth')           
            self.StealthEnh = false
            self.CloakEnh = false 
            self.StealthFieldEffects = false
            self.CloakingEffects = false     
        elseif enh == 'ResourceAllocation' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEnh.ProductionPerSecondEnergy + bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEnh.ProductionPerSecondMass + bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'ResourceAllocationRemove' then
            local bpEcon = self:GetBlueprint().Economy
            self:SetProductionPerSecondEnergy(bpEcon.ProductionPerSecondEnergy or 0)
            self:SetProductionPerSecondMass(bpEcon.ProductionPerSecondMass or 0)
        elseif enh == 'CloakingGenerator' then
            self.StealthEnh = false
			self.CloakEnh = true 
            self:EnableUnitIntel('Cloak')
            if not Buffs['CybranACUCloakBonus'] then
               BuffBlueprint {
                    Name = 'CybranACUCloakBonus',
                    DisplayName = 'CybranACUCloakBonus',
                    BuffType = 'ACUCLOAKBONUS',
                    Stacks = 'ALWAYS',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                    },
                } 
            end
            if Buff.HasBuff( self, 'CybranACUCloakBonus' ) then
                Buff.RemoveBuff( self, 'CybranACUCloakBonus' )
            end  
            Buff.ApplyBuff(self, 'CybranACUCloakBonus')
        elseif enh == 'CloakingGeneratorRemove' then
            self:RemoveToggleCap('RULEUTC_CloakToggle')
            self:DisableUnitIntel('Cloak')
            self.CloakEnh = false 
            if Buff.HasBuff( self, 'CybranACUCloakBonus' ) then
                Buff.RemoveBuff( self, 'CybranACUCloakBonus' )
            end              


		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# GESTION DES BuildRestrictions : GARE AUX PERTES DE MODIFS !
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        #T2 Engineering
        elseif enh =='AdvancedEngineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()


            if not Buffs['CybranACUT2BuildRate'] then
                BuffBlueprint {
                    Name = 'CybranACUT2BuildRate',
                    DisplayName = 'CybranACUT2BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'CybranACUT2BuildRate')


        elseif enh =='AdvancedEngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'CybranACUT2BuildRate' ) then
                Buff.RemoveBuff( self, 'CybranACUT2BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.CYBRAN * (categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then
				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then
					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end
					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end
				end
			end


        #T3 Engineering
        elseif enh =='T3Engineering' then

			local cat = ParseEntityCategory( bpEnh.BuildableCategoryAdds )
			self:RemoveBuildRestriction( cat )

			if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
			and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
				for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
					cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
					self:AddBuildRestriction( cat )
				end
			end

			self:RequestRefreshUI()

            if not Buffs['CybranACUT3BuildRate'] then
                BuffBlueprint {
                    Name = 'CybranACUT3BuildRate',
                    DisplayName = 'CybranCUT3BuildRate',
                    BuffType = 'ACUBUILDRATE',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        BuildRate = {
                            Add =  bpEnh.NewBuildRate - self:GetBlueprint().Economy.BuildRate,
                            Mult = 1,
                        },
                        MaxHealth = {
                            Add = bpEnh.NewHealth,
                            Mult = 1.0,
                        },
                        Regen = {
                            Add = bpEnh.NewRegenRate,
                            Mult = 1.0,
                        },
                    },
                }
            end
            Buff.ApplyBuff(self, 'CybranACUT3BuildRate')


        elseif enh =='T3EngineeringRemove' then

            local bpEconBR = self:GetBlueprint().Economy.BuildRate
            if not bpEconBR then return end

            if Buff.HasBuff( self, 'CybranACUT3BuildRate' ) then
                Buff.RemoveBuff( self, 'CybranACUT3BuildRate' )
            end

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# N.B. : PROVOQUE PERTE DE RESTRICTIONS SPCIFIQUES AJOUTES VIA LE MOD
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
            --self:RestoreBuildRestrictions()
            --self:AddBuildRestriction( categories.CYBRAN * ( categories.BUILTBYTIER2COMMANDER + categories.BUILTBYTIER3COMMANDER) )

			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			# PAR MANIMAL : GESTION DES RESTRICTIONS SINON PERTE DE MODIFS !
			# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
			--# Suppression de 'T3Engineering'
			local preReq = bpEnh.Prerequisite
			if  preReq  and  preReq != nil  then

				local bpPreReq = self:GetBlueprint().Enhancements[preReq]
				if  bpPreReq  and  bpPreReq != nil  then

					local cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
					if  cat  and  cat != nil  then
						self:AddBuildRestriction( cat )
						self:RequestRefreshUI()
					end

					--# Suppression de 'AdvancedEngineering'
					preReq = bpPreReq.Prerequisite
					if  preReq  and  preReq != nil  then
						bpPreReq = self:GetBlueprint().Enhancements[preReq]
						if  bpPreReq  and  bpPreReq != nil  then
							cat = ParseEntityCategory( bpPreReq.BuildableCategoryAdds )
							if  cat  and  cat != nil  then
								self:AddBuildRestriction( cat )
								self:RequestRefreshUI()
							end
						end  --# END  IF  bpPreReq  T2
					end  --# END  IF  preReq  T2

					if  self.catBatimentsDejaContruits  and  self.catBatimentsDejaContruits != nil
					and  table.getsize( self.catBatimentsDejaContruits ) > 0  then
						for i, uneCat in ipairs( self.catBatimentsDejaContruits ) do
							cat = ParseEntityCategory( self.catBatimentsDejaContruits[i] )
							self:AddBuildRestriction( cat )
						end
						self:RequestRefreshUI()
					end

				end  --# END  IF  bpPreReq  T3
			end  --# END  IF  preReq  T3

		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		# FIN DE GESTION DES BuildRestrictions - SCRIPT de MANIMAL
		# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        elseif enh =='CoolingUpgrade' then
            local wep = self:GetWeaponByLabel('RightRipper')
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
            wep:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            wep:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
            wep2:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            wep2:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
			wep3:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            wep3:ChangeRateOfFire(bpEnh.NewRateOfFire or 2)
            local microwave = self:GetWeaponByLabel('MLG')
            microwave:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpEnh.NewMaxRadius or 44)
        elseif enh == 'CoolingUpgradeRemove' then
            local wep = self:GetWeaponByLabel('RightRipper')
			local wep2 = self:GetWeaponByLabel('VeteUpgrade1Gun')
			local wep3 = self:GetWeaponByLabel('VeteUpgrade2Gun')
            local bpDisrupt = self:GetBlueprint().Weapon[1].RateOfFire
            wep:ChangeRateOfFire(bpDisrupt or 1)
			wep2:ChangeRateOfFire(bpDisrupt or 1)
			wep3:ChangeRateOfFire(bpDisrupt or 1)
            bpDisrupt = self:GetBlueprint().Weapon[1].MaxRadius            
            wep:ChangeMaxRadius(bpDisrupt or 22)
			wep2:ChangeMaxRadius(bpDisrupt or 22)
			wep3:ChangeMaxRadius(bpDisrupt or 22)
            local microwave = self:GetWeaponByLabel('MLG')
            microwave:ChangeMaxRadius(bpDisrupt or 22)
            local oc = self:GetWeaponByLabel('OverCharge')
            oc:ChangeMaxRadius(bpDisrupt or 22)            
        elseif enh == 'MicrowaveLaserGenerator' then
            self:SetWeaponEnabledByLabel('MLG', true)
        elseif enh == 'MicrowaveLaserGeneratorRemove' then
            self:SetWeaponEnabledByLabel('MLG', false)
        elseif enh == 'NaniteTorpedoTube' then
            self:SetWeaponEnabledByLabel('Torpedo', true)
            self:EnableUnitIntel('Sonar')
        elseif enh == 'NaniteTorpedoTubeRemove' then
            self:SetWeaponEnabledByLabel('Torpedo', false)
			self:DisableUnitIntel('Sonar')
        end             
    end,
    
}   
    
TypeClass = MRL0001
