--[[#######################################################################
#  File     :  /units/QuantumHeroesGate/UEL0002/UEL0002_script.lua
#  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#  Summary  :  Special UEF Commander Script
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  Driv   :  Forged Alliance -> /units/UEL0001/UEL0001_script.lua
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  14 dcembre 2009
#  Rev.Date :  17 fvrier 2010
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local Shield = import('/lua/shield.lua').Shield

local EffectTemplate = import('/lua/EffectTemplates.lua')
local Buff = import('/lua/sim/Buff.lua')
local utilities = import('/lua/Utilities.lua')
local explosion = import('/lua/defaultexplosions.lua')

# AJOUT DE MANIMAL
--local TWalkingLandUnit = import('/lua/terranunits.lua').TWalkingLandUnit
local THeroWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua' ).THeroWalkingLandUnit

local TerranWeaponFile = import('/lua/terranweapons.lua')
local TIFCommanderDeathWeapon = TerranWeaponFile.TIFCommanderDeathWeapon
local GatlingGun = TerranWeaponFile.TAMPhalanxWeapon

# MODIFS DE MANIMAL (INUTILISS !)
#local RandomFloat = utilities.GetRandomFloat
#local EffectUtil = import('/lua/EffectUtilities.lua')
#local TDFZephyrCannonWeapon = TerranWeaponFile.TDFZephyrCannonWeapon
#local TIFCruiseMissileLauncher = TerranWeaponFile.TIFCruiseMissileLauncher
#local TDFOverchargeWeapon = TerranWeaponFile.TDFOverchargeWeapon


UEL0002 = Class( THeroWalkingLandUnit ) {

    DeathThreadDestructionWaitTime = 2,

    Weapons = {
        DeathWeapon = Class(TIFCommanderDeathWeapon) {},
        AntiLandZephyr = Class(GatlingGun) {
		
		PlayFxWeaponUnpackSequence = function(self)
                    if not self.SpinManip then 
                        self.SpinManip = CreateRotator(self.unit, 'VeteUpgradePart04', 'z', nil, 200, 150, 40)
                        self.unit.Trash:Add(self.SpinManip)
                    end
					if not self.SpinManip2 then 
                        self.SpinManip2 = CreateRotator(self.unit, 'VeteUpgradePart02', 'z', nil, 200, 150, 40)
                        self.unit.Trash:Add(self.SpinManip2)
                    end
                    if self.SpinManip then
                        self.SpinManip:SetTargetSpeed(270)
                    end
					if self.SpinManip2 then
                        self.SpinManip2:SetTargetSpeed(270)
                    end
                    GatlingGun.PlayFxWeaponUnpackSequence(self)
                end,

                PlayFxWeaponPackSequence = function(self)
                    if self.SpinManip then
                        self.SpinManip:SetTargetSpeed(0)
                    end
					if self.SpinManip2 then
                        self.SpinManip2:SetTargetSpeed(0)
                    end
                    GatlingGun.PlayFxWeaponPackSequence(self)
                end,
		
		},

		AntiAirZephyr = Class(GatlingGun) {

		PlayFxWeaponUnpackSequence = function(self)
                    if not self.SpinManip then 
                        self.SpinManip = CreateRotator(self.unit, 'VeteUpgradePart04', 'z', nil, 200, 150, 40)
                        self.unit.Trash:Add(self.SpinManip)
                    end
					if not self.SpinManip2 then 
                        self.SpinManip2 = CreateRotator(self.unit, 'VeteUpgradePart02', 'z', nil, 200, 150, 40)
                        self.unit.Trash:Add(self.SpinManip2)
                    end
                    if self.SpinManip then
                        self.SpinManip:SetTargetSpeed(270)
                    end
					if self.SpinManip2 then
                        self.SpinManip2:SetTargetSpeed(270)
                    end
                    GatlingGun.PlayFxWeaponUnpackSequence(self)
                end,

                PlayFxWeaponPackSequence = function(self)
                    if self.SpinManip then
                        self.SpinManip:SetTargetSpeed(0)
                    end
					if self.SpinManip2 then
                        self.SpinManip2:SetTargetSpeed(0)
                    end
                    GatlingGun.PlayFxWeaponPackSequence(self)
                end,
		
		},

    },


    OnCreate = function(self)
        THeroWalkingLandUnit.OnCreate(self)    --MODIF PAR MANIMAL TWalkingLandUnit.OnCreate(self) 
        self:HideBone('VeteUpgradePart113', true)
        self:HideBone('VeteUpgradePart0101', true)

        self:SetUnSelectable(true)
    end,


    OnStopBeingBuilt = function(self,builder,layer)
        THeroWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)    --MODIF PAR MANIMAL TWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('AntiAirZephyr', false)
        self:SetUnSelectable(true)
        self:SetBusy(true)
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,



    PlayCommanderWarpInEffect = function(self)
        self:HideBone(0, true)
        self:SetUnSelectable(true)
        self:SetBusy(true)
        self:SetBlockCommandQueue(true)
        self:ForkThread(self.WarpInEffectThread)
    end,


    WarpInEffectThread = function(self)
        self:PlayUnitSound('CommanderArrival')
        self:CreateProjectile( MyModPath .. '/hook/effects/entities/UnitTeleport04/UnitTeleport04_proj.bp', 0, 1.35, 0, nil, nil, nil):SetCollision(false)
        WaitSeconds(3.1)
        self:SetMesh( MyModPath .. '/units/QuantumHeroesGate/uel0002/uel0002_PhaseShield_mesh', true)
        self:SetUnSelectable(false)
        self:SetBusy(false)
        self:SetBlockCommandQueue(false)
        self:HideBone('VeteUpgradePart113', true)
        self:HideBone('VeteUpgradePart0101', true)
	
        local totalBones = self:GetBoneCount() - 1
        local army = self:GetArmy()
        for k, v in EffectTemplate.UnitTeleportSteam01 do
            for bone = 1, totalBones do
                CreateAttachedEmitter(self,bone,army, v)
            end
        end

        WaitSeconds(6)
        self:SetMesh(self:GetBlueprint().Display.MeshBlueprint, true)
    end,


    TransformThread = function(self, land)
        if( not self.AnimManip ) then
            self.AnimManip = CreateAnimator(self)
        end
        local bp = self:GetBlueprint()
        local scale = bp.Display.UniformScale or 1

        if( land ) then
			self:SetWeaponEnabledByLabel('AntiLandZephyr', false)
            self.AnimManip:PlayAnim(self:GetBlueprint().Display.AnimationTransform)
            self.AnimManip:SetRate(5)
            self.IsWaiting = true
            WaitFor(self.AnimManip)
			self.IsWaiting = false
            self.Trash:Add(self.AnimManip)
			self:SetWeaponEnabledByLabel('AntiAirZephyr', true)
			self:GetWeaponManipulatorByLabel('AntiAirZephyr'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('AntiLandZephyr'):GetHeadingPitch() )
        else
            self:SetWeaponEnabledByLabel('AntiAirZephyr', false)
            self.AnimManip:PlayAnim(self:GetBlueprint().Display.AnimationTransform)
            self.AnimManip:SetAnimationFraction(1)
            self.AnimManip:SetRate(-5)
            self.IsWaiting = true
            WaitFor(self.AnimManip)
			self.IsWaiting = false
            self.AnimManip:Destroy()
            self.AnimManip = nil
			self:SetWeaponEnabledByLabel('AntiLandZephyr', true)
			self:GetWeaponManipulatorByLabel('AntiLandZephyr'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('AntiAirZephyr'):GetHeadingPitch() )
        end
    end,


    CreateFirePlumes = function( self, army, bones, yBoneOffset )
        local proj, position, offset, velocity
        local basePosition = self:GetPosition()
        for k, vBone in bones do
            position = self:GetPosition(vBone)
            offset = utilities.GetDifferenceVector( position, basePosition )
            velocity = utilities.GetDirectionVector( position, basePosition ) # 
            velocity.x = velocity.x + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.z = velocity.z + utilities.GetRandomFloat(-0.3, 0.3)
            velocity.y = velocity.y + utilities.GetRandomFloat( 9, 0.3)
            proj = self:CreateProjectile( MyModPath .. '/hook/effects/entities/UnitTeleport05/UnitTeleport05_proj.bp', offset.x, offset.y + yBoneOffset, offset.z, velocity.x, velocity.y, velocity.z)
            proj:SetBallisticAcceleration(utilities.GetRandomFloat(-4, -6)):SetVelocity(utilities.GetRandomFloat(9, 11)):SetCollision(false)
            
            local emitter = CreateEmitterOnEntity(proj, army, '/effects/emitters/unit_upgrade_bone_ambient_01_emit.bp'):ScaleEmitter(0.5)

            local lifetime = utilities.GetRandomFloat( 20, 32 )
        end
    end,


    CreateExplosionDebris = function( self, army )
        for k, v in EffectTemplate.ExplosionDebrisLrg01 do
            CreateAttachedEmitter( self, 'Torso', army, v )
        end
    end,


	DeathThread = function(self)
		local army = self:GetArmy()
		self:CreateFirePlumes( army, {'Torso','Torso','Head','Torso','Head','Torso', }, 0.2 )				
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 4.0 )
		self:PlayUnitSound('Killed')
		WaitSeconds(2)
		explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 4.0 )
		self:PlayUnitSound('Killed')
        WaitSeconds(1)
		self:Destroy()
	end, 


    OnScriptBitSet = function(self, bit)
        THeroWalkingLandUnit.OnScriptBitSet(self, bit)    --MODIF PAR MANIMAL TWalkingLandUnit.OnScriptBitSet(self, bit)
        if bit == 1 then 
			self.AT1 = self:ForkThread(self.TransformThread, true)
        end
    end,

    OnScriptBitClear = function(self, bit)
        THeroWalkingLandUnit.OnScriptBitClear(self, bit)    --MODIF PAR MANIMAL TWalkingLandUnit.OnScriptBitClear(self, bit)
        if bit == 1 then 
			self.AT1 = self:ForkThread(self.TransformThread, false)
        end
    end,


	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 1000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 3000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then

				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 4000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then

				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 5000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	end,		


	# POUR TRAAGE
    --OnKilled = function( self, instigator, type, overkillRatio )
    --    THeroWalkingLandUnit.OnKilled( self, instigator, type, overkillRatio )
    --end,


}

TypeClass = UEL0002
