--[[#######################################################################
#  File     :  /units/QuantumHeroesGate/XSB0110/XSB0110_script.lua
#  Author(s):  John Comes, David Tomandl, Gordon Duclos
#  Summary  :  Special SERAPHIM Quantum Gate Script
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  24 fvrier 2010
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--


#######################################################################
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#######################################################################

local SPortalFactoryUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua' ).SPortalFactoryUnit


XSB0110 = Class( SPortalFactoryUnit ) {

	BuildAttachBone = 'BuildAttachBone',


    OnStopBeingBuilt = function(self,builder,layer)
        SPortalFactoryUnit.OnStopBeingBuilt(self, builder, layer)
    end,


    OnStartBuild = function(self, unitBeingBuilt, order)
        SPortalFactoryUnit.OnStartBuild(self, unitBeingBuilt, order)
		
		self.Effect1 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), '/effects/emitters/seraphim_gate_05_emit.bp')
		self.Effect2 = CreateAttachedEmitter(self,'Attachpoint01',self:GetArmy(), '/effects/emitters/seraphim_gate_04_emit.bp')
		self.Effect3 = CreateAttachedEmitter(self,'Attachpoint01',self:GetArmy(), '/effects/emitters/seraphim_gate_03_emit.bp')
		self.Effect4 = CreateAttachedEmitter(self,'Attachpoint03',self:GetArmy(), '/effects/emitters/seraphim_gate_02_emit.bp')
		self.Effect5 = CreateAttachedEmitter(self,'Attachpoint03',self:GetArmy(), '/effects/emitters/urc1501_ambient_02_emit.bp')

		#self.Effect6 = CreateAttachedEmitter(self,'Attachpoint05',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect7 = CreateAttachedEmitter(self,'Attachpoint06',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect8 = CreateAttachedEmitter(self,'Attachpoint07',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect9 = CreateAttachedEmitter(self,'Attachpoint08',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect10 = CreateAttachedEmitter(self,'Attachpoint09',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect11 = CreateAttachedEmitter(self,'Attachpoint10',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect12 = CreateAttachedEmitter(self,'Attachpoint11',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect13 = CreateAttachedEmitter(self,'Attachpoint12',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect14 = CreateAttachedEmitter(self,'Attachpoint13',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')
		#self.Effect15 = CreateAttachedEmitter(self,'Attachpoint14',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_05_emit.bp')

		#self.Effect16 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_04_emit.bp')

		#self.Effect17 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), MyModPath .. '/hook/effects/emitters/economy_electricity_02_emit.bp')

		#self.Effect18 = CreateAttachedEmitter(self,'Attachpoint15',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		#self.Effect19 = CreateAttachedEmitter(self,'Attachpoint16',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_muzzle_05_emit.bp')
		#self.Effect20 = CreateAttachedEmitter(self,'Attachpoint02',self:GetArmy(), '/effects/emitters/uef_orbital_death_laser_end_08_emit.bp')
		
		self.Trash:Add(self.Effecct1)
		self.Trash:Add(self.Effecct2)
		self.Trash:Add(self.Effecct3)
		self.Trash:Add(self.Effecct4)
		self.Trash:Add(self.Effecct5)
		self.UnitBeingBuilt = unitBeingBuilt
        self.UnitBuildOrder = order
        self.BuildingUnit = true
    end,

    OnFailedToBuild = function(self)
		SPortalFactoryUnit.OnFailedToBuild(self)
    end,

    OnStopBuild = function(self, unitBeingBuilt, order )
        SPortalFactoryUnit.OnStopBuild(self, unitBeingBuilt, order )
		if self.Effect1 then
                self.Effect1:Destroy()
				self.Effect2:Destroy()
				self.Effect3:Destroy()
				self.Effect4:Destroy()
				self.Effect5:Destroy()
        end        

        if not self.FactoryBuildFailed then
            if not EntityCategoryContains(categories.AIR, unitBeingBuilt) then
                self:RollOffUnit()
            end
            self:StopBuildFx()
            self:ForkThread(self.FinishBuildThread, unitBeingBuilt, order )
        end
        self.BuildingUnit = false
    end,
	
	
    FinishBuildThread = function(self, unitBeingBuilt, order )
        local bp = self:GetBlueprint()
        if unitBeingBuilt and not unitBeingBuilt:IsDead() then
            unitBeingBuilt:DetachFrom(true)
        end
    end,
	
}

TypeClass = XSB0110
