#****************************************************************************
#**
#**  File     :  /cdimage/units/URB4206/URB4206_script.lua
#**  Author(s):  David Tomandl, Greg Kohne
#**
#**  Summary  :  Cybran Shield Generator lvl 4 Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#**	Note Asdru 16/07/011 :
#**		J'ai utilis une fonction deja presente dans le default units " LandBuiltHiddenBones "
#**	 	Cette derniere permet de faire apparaitre/disparaitre un bones quand la structure est construite sur terre ou sur mer 
#**	 	Voir tourelle anti air et autre pour exemple batiments amphibie
#** 	A noter que la fonction semble buguer quand les batiments sont construits via upgrades
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local CShieldStructureUnit = import( MyModPath .. '/hook/lua/cybranunits.lua').CShieldStructureUnit
local Shield = import('/lua/shield.lua').Shield


URB4206 = Class(CShieldStructureUnit) {
    
	##LandBuiltHiddenBones = {'Flotteur'}, ##-- Ne Semble pas etre pris en compte lorsque le batiment est construit a partir d'un upgrade.	
	
    ShieldEffects = { 
                    '/effects/emitters/cybran_shield_04_generator_01_emit.bp',
                    '/effects/emitters/cybran_shield_04_generator_02_emit.bp',
                    '/effects/emitters/cybran_shield_04_generator_03_emit.bp',
                    },
    
    OnStopBeingBuilt = function(self,builder,layer)
        CShieldStructureUnit.OnStopBeingBuilt(self,builder,layer)
        self.Rotator1 = CreateRotator(self, 'Shaft', 'z', nil, 30, 5, 30)
        self.Trash:Add(self.Rotator1)
		self.ShieldEffectsBag = {}
    end,

    OnShieldEnabled = function(self)
        CShieldStructureUnit.OnShieldEnabled(self)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        if self.Rotator1 then
            self.Rotator1:SetTargetSpeed(10)
        end
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
        for k, v in self.ShieldEffects do
            table.insert( self.ShieldEffectsBag, CreateAttachedEmitter( self, 'Shaft', self:GetArmy(), v ) )
        end
    end,

    OnShieldDisabled = function(self)
        CShieldStructureUnit.OnShieldDisabled(self)
		##--Seul Moyen trouv pour forcer l'apparition du flotteur quand case eau. 
		##-- *Note j'ai tent de bidouiller le default units.lua en ajoutant le " layer " dans les function d'upgrade, ca marchait mais generait une erreur.
		##-- Si plus tard tu veux regarder hesites pas.
		if self:GetCurrentLayer() == 'Water' then
            self:ShowBone('Flotteur', true)
		elseif self:GetCurrentLayer() == 'Land' then
            self:HideBone('Flotteur', true)
        end 
		###////
        self.Rotator1:SetTargetSpeed(0)        
        if self.ShieldEffectsBag then
            for k, v in self.ShieldEffectsBag do
                v:Destroy()
            end
		    self.ShieldEffectsBag = {}
		end
    end,
}

TypeClass = URB4206