#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0401/UEL0401_script.lua
#**  Author(s):  John Comes, David Tomandl, Gordon Duclos
#**
#**  Summary  :  UEF Mobile Factory Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TLandUnit
local WeaponsFile = import('/lua/terranweapons.lua')
local TDFGaussCannonWeapon = WeaponsFile.TDFLandGaussCannonWeapon
local TDFRiotWeapon = WeaponsFile.TDFRiotWeapon
local TAALinkedRailgun = WeaponsFile.TAALinkedRailgun
local TANTorpedoAngler = WeaponsFile.TANTorpedoAngler

####UPGRADE04
local TIFFragLauncherWeapon = WeaponsFile.TDFFragmentationGrenadeLauncherWeapon
local TSAMLauncher = import('/lua/terranweapons.lua').TSAMLauncher

local EffectTemplate = import('/lua/EffectTemplates.lua')

local EffectUtil = import('/lua/EffectUtilities.lua')
local CreateUEFBuildSliceBeams = EffectUtil.CreateUEFBuildSliceBeams


local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0401 = Class(TLandUnit) {
    Weapons = {
        RightTurret01 = Class(TDFGaussCannonWeapon) {},
        RightTurret02 = Class(TDFGaussCannonWeapon) {},
        LeftTurret01 = Class(TDFGaussCannonWeapon) {},
        LeftTurret02 = Class(TDFGaussCannonWeapon) {},
        RightRiotgun = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
        LeftRiotgun = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
        RightAAGun = Class(TAALinkedRailgun) {},
        LeftAAGun = Class(TAALinkedRailgun) {},
        Torpedo = Class(TANTorpedoAngler) {},
	##########UPGRADE02
		CenterTurret01 = Class(TDFGaussCannonWeapon) {},
        CenterTurret02 = Class(TDFGaussCannonWeapon) {},
	##########UPGRADE03
		FrontRiotgun01 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun02 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun03 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun04 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun05 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun06 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun07 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
		FrontRiotgun08 = Class(TDFRiotWeapon) {
            FxMuzzleFlash = EffectTemplate.TRiotGunMuzzleFxTank
        },
	##########UPGRADE04
		HeavyGrenade01 = Class(TSAMLauncher) {},
		HeavyGrenade02 = Class(TSAMLauncher) {},
		####Toggled
		MissileRack01 = Class(TSAMLauncher) {},
		MissileRack02 = Class(TSAMLauncher) {},
    },
	
	OnCreate = function(self)
        TLandUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		self:HideBone('Upgrade01_03', true)
		self:HideBone('Upgrade01_04', true)
		self:HideBone('Upgrade01_05', true)
		self:HideBone('Upgrade01_06', true)
		self:HideBone('Upgrade01_07', true)
		self:HideBone('Upgrade01_08', true)
		self:HideBone('Upgrade01_09', true)
		self:HideBone('Upgrade01_10', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		self:HideBone('Upgrade03_03', true)
		self:HideBone('Upgrade03_04', true)
		self:HideBone('Upgrade03_05', true)
		self:HideBone('Upgrade03_06', true)
		self:HideBone('Upgrade03_07', true)
		self:HideBone('Upgrade03_08', true)
		self:HideBone('Upgrade03_09', true)
		self:HideBone('Upgrade03_10', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		self:HideBone('Upgrade04_02', true)
		self:RemoveToggleCap('RULEUTC_WeaponToggle')
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self:HideBone('Upgrade05_02', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,	
	
	OnStopBeingBuilt = function(self, builder,layer)
        TLandUnit.OnStopBeingBuilt(self, builder,layer)
		self:SetWeaponEnabledByLabel('RightTurret01', true)
		self:SetWeaponEnabledByLabel('RightTurret02', true)
		self:SetWeaponEnabledByLabel('LeftTurret01', true)
		self:SetWeaponEnabledByLabel('LeftTurret02', true)		
		self:SetWeaponEnabledByLabel('RightRiotgun', true)
		self:SetWeaponEnabledByLabel('LeftRiotgun', true)
		self:SetWeaponEnabledByLabel('RightAAGun', true)
		self:SetWeaponEnabledByLabel('LeftAAGun', true)
		self:SetWeaponEnabledByLabel('Torpedo', true)
		###UPGRADE02
		self:SetWeaponEnabledByLabel('CenterTurret01', false)
		self:SetWeaponEnabledByLabel('CenterTurret02', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('FrontRiotgun01', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun02', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun03', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun04', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun05', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun06', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun07', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun08', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun09', false)
		self:SetWeaponEnabledByLabel('FrontRiotgun10', false)	
		###UPGRADE04
		self:SetWeaponEnabledByLabel('HeavyGrenade01', false)
		self:SetWeaponEnabledByLabel('HeavyGrenade02', false)
				###toggled
			self:SetWeaponEnabledByLabel('MissileRack01', false)
			self:SetWeaponEnabledByLabel('MissileRack02', false)	
			
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,	
	
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 10% et range 10%
				local wep1 = self:GetWeaponByLabel('RightTurret01')
				wep1:AddDamageMod(bpEnh.GaussIDamageMod)
				wep1:ChangeMaxRadius(110)
				local wep2 = self:GetWeaponByLabel('RightTurret02')
				wep2:AddDamageMod(bpEnh.GaussIDamageMod)
				wep2:ChangeMaxRadius(110)				
				local wep3 = self:GetWeaponByLabel('LeftTurret01')
				wep3:AddDamageMod(bpEnh.GaussIDamageMod)
				wep3:ChangeMaxRadius(110)				
				local wep4 = self:GetWeaponByLabel('LeftTurret02')
				wep4:AddDamageMod(bpEnh.GaussIDamageMod)
				wep4:ChangeMaxRadius(110)				
				local wep5 = self:GetWeaponByLabel('CenterTurret01')
				wep5:AddDamageMod(bpEnh.GaussIDamageMod)
				wep5:ChangeMaxRadius(110)				
				local wep6 = self:GetWeaponByLabel('CenterTurret02')
				wep6:AddDamageMod(bpEnh.GaussIDamageMod)
				wep6:ChangeMaxRadius(110)				
				local wep7 = self:GetWeaponByLabel('RightRiotgun')
				wep7:AddDamageMod(bpEnh.AAIDamageMod)
				wep7:ChangeMaxRadius(50)
				local wep8 = self:GetWeaponByLabel('LeftRiotgun')
				wep8:AddDamageMod(bpEnh.AAIDamageMod)
				wep8:ChangeMaxRadius(50)				
				local wep9 = self:GetWeaponByLabel('RightAAGun')
				wep9:AddDamageMod(bpEnh.RiotIDamageMod)
				wep9:ChangeMaxRadius(50)
				local wep10 = self:GetWeaponByLabel('LeftAAGun')
				wep10:AddDamageMod(bpEnh.RiotIDamageMod)
				wep10:ChangeMaxRadius(50)				
				local wep10 = self:GetWeaponByLabel('Torpedo')
				wep10:AddDamageMod(bpEnh.TorpIDamageMod)
				wep10:ChangeMaxRadius(45)
				###Bones
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				self:ShowBone('Upgrade01_05', true)
				self:ShowBone('Upgrade01_06', true)
				self:ShowBone('Upgrade01_07', true)
				self:ShowBone('Upgrade01_08', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFI',
                    DisplayName = 'UEFHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 5000,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon				
				self:ShowBone('Upgrade02_01', true)
				self:SetWeaponEnabledByLabel('CenterTurret01', true)
				self:SetWeaponEnabledByLabel('CenterTurret02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFII',
                    DisplayName = 'UEFHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
			
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:ShowBone('Upgrade03_03', true)
				self:ShowBone('Upgrade03_04', true)
				self:ShowBone('Upgrade03_05', true)
				self:ShowBone('Upgrade03_06', true)
				self:ShowBone('Upgrade03_07', true)
				self:ShowBone('Upgrade03_08', true)
				self:ShowBone('Upgrade03_09', true)
				self:ShowBone('Upgrade03_10', true)
				
				self:SetWeaponEnabledByLabel('FrontRiotgun01', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun02', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun03', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun04', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun05', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun06', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun07', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun08', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun09', true)
				self:SetWeaponEnabledByLabel('FrontRiotgun10', true)	
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIII',
                    DisplayName = 'UEFHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 14500,
                            Mult = 0.9,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				
				self:AddToggleCap('RULEUTC_WeaponToggle')
				
				--self:SetWeaponEnabledByLabel('MissileRack01', true)
				--self:SetWeaponEnabledByLabel('MissileRack02', true)
				
				self:SetWeaponEnabledByLabel('HeavyGrenade01', true)
				self:SetWeaponEnabledByLabel('HeavyGrenade02', true)
				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIV',
                    DisplayName = 'UEFHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 277,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFV',
                    DisplayName = 'UEFHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 195,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFV')
		end		
	end,			
	
	
	OnScriptBitSet = function(self, bit)
        TLandUnit.OnScriptBitSet(self, bit)
        if bit == 1 then 
            self:SetWeaponEnabledByLabel('HeavyGrenade01', false)
			self:SetWeaponEnabledByLabel('HeavyGrenade02', false)
            self:SetWeaponEnabledByLabel('MissileRack01', true)
			self:SetWeaponEnabledByLabel('MissileRack02', true)
            --self:GetWeaponManipulatorByLabel('HeavyGrenade01'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('MissileRack01'):GetHeadingPitch() )
			--self:GetWeaponManipulatorByLabel('HeavyGrenade02'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('MissileRack02'):GetHeadingPitch() )
        end
    end,

    OnScriptBitClear = function(self, bit)
        TLandUnit.OnScriptBitClear(self, bit)
        if bit == 1 then 
            self:SetWeaponEnabledByLabel('HeavyGrenade01', true)
			self:SetWeaponEnabledByLabel('HeavyGrenade02', true)
            self:SetWeaponEnabledByLabel('MissileRack01', false)
			self:SetWeaponEnabledByLabel('MissileRack02', false)
            --self:GetWeaponManipulatorByLabel('MissileRack01'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('HeavyGrenade01'):GetHeadingPitch() )
			--self:GetWeaponManipulatorByLabel('MissileRack02'):SetHeadingPitch( self:GetWeaponManipulatorByLabel('HeavyGrenade02'):GetHeadingPitch() )
        end
    end,
	
	--[[
    FxDamageScale = 2.5,
    --PrepareToBuildAnimRate = 5,
    BuildAttachBone = 'Build_Attachpoint',


    OnStopBeingBuilt = function(self,builder,layer)
        TLandUnit.OnStopBeingBuilt(self,builder,layer)
        self.EffectsBag = {}
        ChangeState(self, self.IdleState)
    end,

    OnFailedToBuild = function(self)
        TLandUnit.OnFailedToBuild(self)
        ChangeState(self, self.IdleState)
    end,

    OnLayerChange = function(self, new, old)
        TLandUnit.OnLayerChange(self, new, old)
        if new == 'Land' then
            self:RestoreBuildRestrictions()
            self:RequestRefreshUI()
        elseif new == 'Seabed' then
            self:AddBuildRestriction(categories.ALLUNITS)
            self:RequestRefreshUI()         
        end
    end,

    IdleState = State {
        OnStartBuild = function(self, unitBuilding, order)
            self:SetBusy(true)
            TLandUnit.OnStartBuild(self, unitBuilding, order)
            self.UnitBeingBuilt = unitBuilding
            --self.PrepareToBuildManipulator:SetRate(self.PrepareToBuildAnimRate)
            --ChangeState(self, self.BuildingState)
        end,

        Main = function(self)
            --self.PrepareToBuildManipulator:SetRate(-self.PrepareToBuildAnimRate)
            self:DetachAll(self.BuildAttachBone)
            self:SetBusy(false)
        end,

    },


	BuildingState = State {

        Main = function(self)
            local unitBuilding = self.UnitBeingBuilt
            self.PrepareToBuildManipulator:SetRate(self.PrepareToBuildAnimRate)
            local bone = self.BuildAttachBone
            self:DetachAll(bone)
            if not self.UnitBeingBuilt:IsDead() then
                unitBuilding:AttachBoneTo( -2, self, bone )
                local unitHeight = unitBuilding:GetBlueprint().SizeY
                self.AttachmentSliderManip:SetGoal(0, unitHeight, 0 )
                self.AttachmentSliderManip:SetSpeed(-1)
                unitBuilding:HideBone(0,true)
            end
            WaitSeconds(3)
            unitBuilding:ShowBone(0,true)
            WaitFor( self.PrepareToBuildManipulator )
            local unitBuilding = self.UnitBeingBuilt
            self.UnitDoneBeingBuilt = false
        end,

        OnStopBuild = function(self, unitBeingBuilt)
            TLandUnit.OnStopBuild(self, unitBeingBuilt)

            ChangeState(self, self.RollingOffState)
        end,

    },

    RollingOffState = State {

        Main = function(self)
            local unitBuilding = self.UnitBeingBuilt
            if not unitBuilding:IsDead() then
                unitBuilding:ShowBone(0,true)
            end
            WaitFor(self.PrepareToBuildManipulator)
            WaitFor(self.AttachmentSliderManip)
            self:CreateRollOffEffects()
            self.AttachmentSliderManip:SetSpeed(10)
            self.AttachmentSliderManip:SetGoal(0, 0, 17)
            WaitFor( self.AttachmentSliderManip )
            self.AttachmentSliderManip:SetGoal(0, -3, 17)
            WaitFor( self.AttachmentSliderManip )
            if not unitBuilding:IsDead() then
                unitBuilding:DetachFrom(true)
                self:DetachAll(self.BuildAttachBone)
                local  worldPos = self:CalculateWorldPositionFromRelative({0, 0, -15})
                IssueMoveOffFactory({unitBuilding}, worldPos)
            end
            self:DestroyRollOffEffects()
            ChangeState(self, self.IdleState)
        end,
    },

    CreateRollOffEffects = function(self)
        local army = self:GetArmy()
        local unitB = self.UnitBeingBuilt
        for k, v in self.RollOffBones do
            local fx = AttachBeamEntityToEntity(self, v, unitB, -1, army, EffectTemplate.TTransportBeam01)
            table.insert( self.ReleaseEffectsBag, fx)
            self.Trash:Add(fx)
            fx = AttachBeamEntityToEntity( unitB, -1, self, v, army, EffectTemplate.TTransportBeam02)
            table.insert( self.ReleaseEffectsBag, fx)
            self.Trash:Add(fx)
            fx = CreateEmitterAtBone( self, v, army, EffectTemplate.TTransportGlow01)
            table.insert( self.ReleaseEffectsBag, fx)
            self.Trash:Add(fx)
        end
    end,

    DestroyRollOffEffects = function(self)
        for k, v in self.ReleaseEffectsBag do
            v:Destroy()
        end
        self.ReleaseEffectsBag = {}
    end,
	]]--
}

TypeClass = UEL0401