--[[#######################################################################
#  File	 :  /units/XSL0405/XSL0405_script.lua
#  Author(s):  Jessica St. Croix, Dru Staltman, Aaron Lundquist
#  Summary  :  Seraphim Experimental Assault Bot
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  20 novembre 2009
#  -----------------------------
#  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--

#######################################################################
local Game = import('/lua/game.lua')

#VARIABLE ''GLOBALE'' (par Manimal)
local MyModPath = Game.MyModPath
#######################################################################


local SWalkingLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua' ).SWalkingLandUnit
local WeaponsFile = import ('/lua/seraphimweapons.lua')
local SDFExperimentalPhasonProj = WeaponsFile.SDFExperimentalPhasonProj
local SDFAireauWeapon = WeaponsFile.SDFAireauWeapon
local SDFSinnuntheWeapon = WeaponsFile.SDFSinnuntheWeapon
local SAAOlarisCannonWeapon = WeaponsFile.SAAOlarisCannonWeapon
local utilities = import('/lua/utilities.lua')
local EffectUtil = import('/lua/EffectUtilities.lua')
local explosion = import('/lua/defaultexplosions.lua')

###UPGRADE 02 03 04 
local SDFUltraChromaticBeamGenerator = import('/lua/seraphimweapons.lua').SDFUltraChromaticBeamGenerator


local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false 
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false



XSL0405 = Class(SWalkingLandUnit) {

    SpawnEffects = {
		'/effects/emitters/seraphim_othuy_spawn_01_emit.bp',
		'/effects/emitters/seraphim_othuy_spawn_02_emit.bp',
		'/effects/emitters/seraphim_othuy_spawn_03_emit.bp',
		'/effects/emitters/seraphim_othuy_spawn_04_emit.bp',
	},
	
    Weapons = {
        EyeWeapon = Class(SDFExperimentalPhasonProj) {},
        LeftArm = Class(SDFAireauWeapon) {},
        RightArm = Class(SDFSinnuntheWeapon)
        {
            PlayFxMuzzleChargeSequence = function(self, muzzle)
                #CreateRotator(unit, bone, axis, [goal], [speed], [accel], [goalspeed])
                if not self.ClawTopRotator then 
                    self.ClawTopRotator = CreateRotator(self.unit, 'Top_Claw', 'x')
                    self.ClawBottomRotator = CreateRotator(self.unit, 'Bottom_Claw', 'x')
                    
                    self.unit.Trash:Add(self.ClawTopRotator)
                    self.unit.Trash:Add(self.ClawBottomRotator)
                end
                
                self.ClawTopRotator:SetGoal(-45):SetSpeed(10)
                self.ClawBottomRotator:SetGoal(45):SetSpeed(10)
                
                SDFSinnuntheWeapon.PlayFxMuzzleChargeSequence(self, muzzle)
                
                self:ForkThread(function()
                    WaitSeconds(self.unit:GetBlueprint().Weapon[3].MuzzleChargeDelay)
                    
                    self.ClawTopRotator:SetGoal(0):SetSpeed(50)
                    self.ClawBottomRotator:SetGoal(0):SetSpeed(50)
                end)
            end,
        },
        
        LeftAA = Class(SAAOlarisCannonWeapon) {},
        RightAA = Class(SAAOlarisCannonWeapon) {},
		####02
		Upgrade02Gun01 = Class(SDFUltraChromaticBeamGenerator) {},
		Upgrade02Gun02 = Class(SDFUltraChromaticBeamGenerator) {},
		####03
		Upgrade03Gun01 = Class(SDFUltraChromaticBeamGenerator) {},
		Upgrade03Gun02 = Class(SDFUltraChromaticBeamGenerator) {},
		####04
		Upgrade04Gun01 = Class(SDFUltraChromaticBeamGenerator) {},
		Upgrade04Gun02 = Class(SDFUltraChromaticBeamGenerator) {},
    },
	
	OnCreate = function(self)
		SWalkingLandUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)
			self:HideBone('Upgrade01_03', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade02_02', true)
			self:HideBone('Upgrade02_03', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
	OnStopBeingBuilt = function(self,builder,layer)
        SWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('EyeWeapon', true)
		self:SetWeaponEnabledByLabel('LeftArm', true)
		self:SetWeaponEnabledByLabel('RightArm', true)
		self:SetWeaponEnabledByLabel('LeftAA', true)
		self:SetWeaponEnabledByLabel('RightArm', true)
		###UPGRADE 2
		self:SetWeaponEnabledByLabel('Upgrade02Gun01', false)
		self:SetWeaponEnabledByLabel('Upgrade02Gun02', false)
		###UPGRADE 3
		self:SetWeaponEnabledByLabel('Upgrade03Gun01', false)
		self:SetWeaponEnabledByLabel('Upgrade03Gun02', false)
		###UPGRADE 3
		self:SetWeaponEnabledByLabel('Upgrade04Gun01', false)
		self:SetWeaponEnabledByLabel('Upgrade04Gun02', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
		
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 20%
				local wep1 = self:GetWeaponByLabel('EyeWeapon')
				local wep2 = self:GetWeaponByLabel('LeftArm')
				local wep3 = self:GetWeaponByLabel('RightArm')
				local wep4 = self:GetWeaponByLabel('LeftAA')
				local wep5 = self:GetWeaponByLabel('RightAA')
				wep1:ChangeMaxRadius(52)
				wep2:ChangeMaxRadius(52)
				wep3:ChangeMaxRadius(52)
				wep4:ChangeMaxRadius(52)
				wep5:ChangeMaxRadius(52)
				###Meshe
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFI',
                    DisplayName = 'AEONHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 16000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade02Gun01', true)
				self:SetWeaponEnabledByLabel('Upgrade02Gun02', true)
				###Meshe
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)
				self:ShowBone('Upgrade02_03', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFII',
                    DisplayName = 'AEONHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				###Meshe
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade03Gun01', true)
				self:SetWeaponEnabledByLabel('Upgrade03Gun02', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIII',
                    DisplayName = 'AEONHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade04Gun01', true)
				self:SetWeaponEnabledByLabel('Upgrade04Gun02', true)
				###Meshe
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIV',
                    DisplayName = 'AEONHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				###Advanced Regen
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade02Laser01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Effect2 = CreateAttachedEmitter(self,'Upgrade02Laser02',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Effect3 = CreateAttachedEmitter(self,'Upgrade03Laser01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Effect4 = CreateAttachedEmitter(self,'Upgrade03Laser02',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Effect5 = CreateAttachedEmitter(self,'Upgrade04Laser01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Effect6 = CreateAttachedEmitter(self,'Upgrade04Laser02',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				self.Trash:Add(self.Effecct2)
				self.Trash:Add(self.Effecct3)
				self.Trash:Add(self.Effecct4)				
				self.Trash:Add(self.Effecct5)
				self.Trash:Add(self.Effecct6)
				###Meshe
				self:ShowBone('Upgrade05_01', true)			
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFV',
                    DisplayName = 'AEONHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },
						Regen = {
                            Add = 500,
                            Mult = 1,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFV')
		end		
	end,			
	
	
    
    StartBeingBuiltEffects = function(self, builder, layer)
		SWalkingLandUnit.StartBeingBuiltEffects(self, builder, layer)
		self:ForkThread( EffectUtil.CreateSeraphimExperimentalBuildBaseThread, builder, self.OnBeingBuiltEffectsBag )
    end,       
    
    OnAnimCollision = function(self, bone, x, y, z)
        SWalkingLandUnit.OnAnimCollision(self, bone, x, y, z)
    end,     
       
    DeathThread = function( self, overkillRatio , instigator)
        local bigExplosionBones = {'Torso', 'Head', 'pelvis'}
        local explosionBones = {'Right_Arm_B07', 'Right_Arm_B03',
                                'Left_Arm_B10', 'Left_Arm_B07',
                                'Chest_B01', 'Chest_B03',
                                'Right_Leg_B01', 'Right_Leg_B02', 'Right_Leg_B03',
                                'Left_Leg_B17', 'Left_Leg_B14', 'Left_Leg_B15'}
                                        
        explosion.CreateDefaultHitExplosionAtBone( self, bigExplosionBones[Random(1,3)], 4.0 )
        explosion.CreateDebrisProjectiles(self, explosion.GetAverageBoundingXYZRadius(self), {self:GetUnitSizes()})           
        WaitSeconds(2)
        
        local RandBoneIter = RandomIter(explosionBones)
        for i=1,Random(4,6) do
            local bone = RandBoneIter()
            explosion.CreateDefaultHitExplosionAtBone( self, bone, 1.0 )
            WaitTicks(Random(1,3))
        end
        
        local bp = self:GetBlueprint()
        for i, numWeapons in bp.Weapon do
            if(bp.Weapon[i].Label == 'CollossusDeath') then
                DamageArea(self, self:GetPosition(), bp.Weapon[i].DamageRadius, bp.Weapon[i].Damage, bp.Weapon[i].DamageType, bp.Weapon[i].DamageFriendly)
                break
            end
        end
        WaitSeconds(3.5)
        explosion.CreateDefaultHitExplosionAtBone( self, 'Torso', 5.0 )        

        if self.DeathAnimManip then
            WaitFor(self.DeathAnimManip)
        end

    
        self:DestroyAllDamageEffects()
        self:CreateWreckage( overkillRatio )

        # CURRENTLY DISABLED UNTIL DESTRUCTION
        # Create destruction debris out of the mesh, currently these projectiles look like crap,
        # since projectile rotation and terrain collision doesn't work that great. These are left in
        # hopes that this will look better in the future.. =)
        if( self.ShowUnitDestructionDebris and overkillRatio ) then
            if overkillRatio <= 1 then
                self.CreateUnitDestructionDebris( self, true, true, false )
            elseif overkillRatio <= 2 then
                self.CreateUnitDestructionDebris( self, true, true, false )
            elseif overkillRatio <= 3 then
                self.CreateUnitDestructionDebris( self, true, true, true )
            else #VAPORIZED
                self.CreateUnitDestructionDebris( self, true, true, true )
            end
        end

        
        # Spawn an engineer (temp energy being)
        local position = self:GetPosition()
        local spiritUnit = CreateUnitHPR('XSL0402', self:GetArmy(), position[1], position[2], position[3], 0, 0, 0)
        
        # Create effects for spawning of energy being
		for k, v in self.SpawnEffects do
			CreateAttachedEmitter(spiritUnit, -1, self:GetArmy(), v )
		end	
        
        self:PlayUnitSound('Destroyed')
        self:Destroy()
    end,
    
}

TypeClass = XSL0405
