--[[#######################################################################
#  File     :  /units/UEA0105/UEA0105_script.lua
#  Author(s):  John Comes, David Tomandl, Jessica St. Croix, Gordon Duclos
#  Summary  :  UEF Gunship Script UEA0203
#  -----------------------------
#  Modif.by :  AsdrubaelVect
#  Rev.Date :  5 septembre 2009
#  -----------------------------
#  Revis.by :  Manimal
#  Rev.Date :  20 novembre 2009
#  -----------------------------
#  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#######################################################################]]--
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TAirUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TAirUnit

local TDFRiotWeapon = import('/lua/terranweapons.lua').TDFRiotWeapon
local TDFMachineGunWeapon = import('/lua/terranweapons.lua').TDFMachineGunWeapon
local CIFBombNeutronWeapon = import('/lua/cybranweapons.lua').CIFBombNeutronWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEA0105 = Class(TAirUnit) {
    EngineRotateBones = {'Jet_Center01','Upgrade01_01'},

    Weapons = {
        Turret01 = Class(TDFMachineGunWeapon) {},
		Turret02 = Class(TDFMachineGunWeapon) {},
		UpgradeGun01 = Class(CIFBombNeutronWeapon) {},

    },
	
    OnCreate = function(self)
		TAirUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true) 			
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)		
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)			
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self,builder,layer)
        TAirUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('Turret01', true)
		self:SetWeaponEnabledByLabel('Turret02', false)
		self:SetWeaponEnabledByLabel('UpgradeGun01', false)

		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran')
        self.EngineManipulators = {}
        for key, value in self.EngineRotateBones do
            table.insert(self.EngineManipulators, CreateThrustController(self, "thruster", value))
        end
        for key,value in self.EngineManipulators do
            #                          XMAX, XMIN, YMAX,YMIN, ZMAX,ZMIN, TURNMULT, TURNSPEED
            value:SetThrustingParam( -0.0, 0.0, -0.25, 0.25, -0.1, 0.1, 1.0,      0.45 )
        end
        for k, v in self.EngineManipulators do
            self.Trash:Add(v)
        end

    end,
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:HideBone('Upgrade02_01', true)	
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = bp.NewHealth,
                            Mult = 1.3,
                        },
                        Regen = {
                            Add = bp.NewRegenRate,
                            Mult = 1,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				local wep = self:GetWeaponByLabel('Turret01')
				wep:AddDamageMod(bpEnh.MitrailIDamageMod)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
						Name = 'UEFHEALTHBUFF',
						DisplayName = 'UEFHEALTHBUFF',
						BuffType = 'MAXHEALTH',
						Stacks = 'REPLACE',
						Duration = -1,
						Affects = {
							MaxHealth = {
								Add = 20,
								Mult = 1.0,
							},
							Health = {
								Add = 100,
								Mult = 1.0,
							},						
						},
					}
				end
				Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
			end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
			
				self:ShowBone('Upgrade03_01', true)
			
				self:SetWeaponEnabledByLabel('Turret02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
						Name = 'UEFHEALTHBUFF',
						DisplayName = 'UEFHEALTHBUFF',
						BuffType = 'MAXHEALTH',
						Stacks = 'REPLACE',
						Duration = -1,
						Affects = {
							Health = {
								Add = 150,
								Mult = 1.0,
							},						
						},
					}
				end
				Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
			end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			
				self:ShowBone('Upgrade04_01', true)
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFII',
                    DisplayName = 'UEFHEALTHBUFFII',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = bp.NewHealth,
                            Mult = 1.15,
                        },
                        Regen = {
                            Add = bp.NewRegenRate,
                            Mult = 1.3,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFII')
		end
		##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
			local wep = self:GetWeaponByLabel('Turret01')
				wep:AddDamageMod(bpEnh.BolterDamageMod)  
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end
	
end,	
}

TypeClass = UEA0105
