#****************************************************************************
#**
#**  File     :  /cdimage/units/UES0103/UES0103_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Frigate Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TSeaUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TSeaUnit
local TAALinkedRailgun = import('/lua/terranweapons.lua').TAALinkedRailgun
local TDFGaussCannonWeapon = import('/lua/terranweapons.lua').TDFGaussCannonWeapon

####UPGRADE03
local TANTorpedoAngler = import('/lua/terranweapons.lua').TANTorpedoAngler
#####UPGRADE04
local TIFCruiseMissileLauncher = import('/lua/terranweapons.lua').TIFCruiseMissileLauncher

local Entity = import('/lua/sim/Entity.lua').Entity
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UES0103 = Class(TSeaUnit) {

    Weapons = {
        MainGun = Class(TDFGaussCannonWeapon) {
        },
		AAGun = Class(TAALinkedRailgun) {
        },
		####UPGRADE01####
        UpgradeGun01 = Class(TDFGaussCannonWeapon) {
        },
        UpgradeGun02 = Class(TDFGaussCannonWeapon) {
        },
        ####UPGRADE02####
        UpgradeAAGun01 = Class(TAALinkedRailgun) {
        },
		####UPGRADE03####
		Torpedo01 = Class(TANTorpedoAngler) {},
		####UPGRADE04
		CruiseMissile = Class(TIFCruiseMissileLauncher) {},
    },

    OnCreate = function(self)
		TSeaUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)	
			--self:HideBone('Upgrade01_02', true)			
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			self:HideBone('Upgrade02_02', true)	
			self:HideBone('Upgrade02_03', true)	
			self:HideBone('Upgrade02_04', true)				
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			##UPGRADE05
			self:HideBone('Upgrade05_01', true)			
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	
    OnStopBeingBuilt = function(self,builder,layer)
        TSeaUnit.OnStopBeingBuilt(self,builder,layer)
        self.Trash:Add(CreateRotator(self, 'Spinner01', 'y', nil, 360, 0, 180))
        self.Trash:Add(CreateRotator(self, 'Spinner02', 'y', nil, 90, 0, 180))
        self.Trash:Add(CreateRotator(self, 'Spinner03', 'y', nil, -180, 0, -180))
		
		self.Trash:Add(CreateRotator(self, 'Spinner04', 'y', nil, 180, 0, 180))
		self.Trash:Add(CreateRotator(self, 'Spinner05', 'y', nil, 180, 0, 180))
		
        self.RadarEnt = Entity {}
        self.Trash:Add(self.RadarEnt)
        self.RadarEnt:InitIntel(self:GetArmy(), 'Radar', self:GetBlueprint().Intel.RadarRadius or 75)
        self.RadarEnt:EnableIntel('Radar')
        self.RadarEnt:InitIntel(self:GetArmy(), 'Sonar', self:GetBlueprint().Intel.SonarRadius or 75)
        self.RadarEnt:EnableIntel('Sonar')
        self.RadarEnt:AttachBoneTo(-1, self, 0)
		self:SetWeaponEnabledByLabel('MainGun', true)
		self:SetWeaponEnabledByLabel('AAGun', true)
		self:SetWeaponEnabledByLabel('UpgradeGun01', false)
		self:SetWeaponEnabledByLabel('UpgradeGun02', false)
		self:SetWeaponEnabledByLabel('UpgradeAAGun01', false)
		self:SetWeaponEnabledByLabel('Torpedo01', false)
		self:SetWeaponEnabledByLabel('CruiseMissile', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
			self:ShowBone('Upgrade01_01', true)	
			self:HideBone('Origine01_01', true)	
			self:HideBone('Upgrade02_01', true)	
			self:HideBone('Upgrade02_02', true)	
			self:HideBone('Upgrade02_03', true)	
			
			self:SetWeaponEnabledByLabel('UpgradeGun01', true)
			self:SetWeaponEnabledByLabel('UpgradeGun02', true)
			
			
			
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 253,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)	
				self:ShowBone('Upgrade02_02', true)	
				self:ShowBone('Upgrade02_03', true)
				self:ShowBone('Upgrade02_04', true)
				
				self:SetWeaponEnabledByLabel('UpgradeAAGun01', true)

				local wep = self:GetWeaponByLabel('MainGun')
				wep:AddDamageMod(bpEnh.CanonIDamageMod)  
				local wep2 = self:GetWeaponByLabel('AAGun')
				wep2:AddDamageMod(bpEnh.AAIDamageMod)  
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)	
				self:ShowBone('Upgrade03_02', true)
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				self:SetWeaponEnabledByLabel('Torpedo01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 400,
                            Mult = 1,
                        },	
						Health = {
                            Add = 350,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			self:ShowBone('Upgrade04_01', true)	
			self:ShowBone('Upgrade04_02', true)	
			self:SetWeaponEnabledByLabel('CruiseMissile', true)
			
			self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 450,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)	
				self:SetIntelRadius('Vision', 50)
				self:SetIntelRadius('Radar', 120)
				self:SetIntelRadius('Sonar', 130)
				
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep2 = self:GetWeaponByLabel('UpgradeGun01')
				local wep3 = self:GetWeaponByLabel('UpgradeGun02')
				local wep4 = self:GetWeaponByLabel('Torpedo01')
				wep1:ChangeMaxRadius(33)
				wep2:ChangeMaxRadius(33)
				wep3:ChangeMaxRadius(33)
				wep4:ChangeMaxRadius(33)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end
	end,	

}

TypeClass = UES0103