#****************************************************************************
#**
#**  File     :  /units/UES0104/UES0104_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Arty Ship Frigate Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local TSeaUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TSeaUnit
local TIFArtilleryWeapon = import('/lua/terranweapons.lua').TIFArtilleryWeapon
local TDFGaussCannonWeapon = import('/lua/terranweapons.lua').TDFGaussCannonWeapon
local TAALinkedRailgun = import('/lua/terranweapons.lua').TAALinkedRailgun

####UPGRADE03
local TANTorpedoAngler = import('/lua/terranweapons.lua').TANTorpedoAngler
#####UPGRADE04
local TIFCruiseMissileLauncher = import('/lua/terranweapons.lua').TIFCruiseMissileLauncher

local Entity = import('/lua/sim/Entity.lua').Entity
local Buff = import('/lua/sim/Buff.lua')

UES0104 = Class(TSeaUnit) {

    Weapons = {
		MainGun = Class(TIFArtilleryWeapon) {},
		####UPGRADE01####
        UpgradeGun01 = Class(TDFGaussCannonWeapon) {
        },
        UpgradeGun02 = Class(TDFGaussCannonWeapon) {
        },
        ####UPGRADE02####
        UpgradeAAGun01 = Class(TAALinkedRailgun) {
        },
		UpgradeAAGun02 = Class(TAALinkedRailgun) {
        },
		####UPGRADE03####
		Torpedo01 = Class(TANTorpedoAngler) {},
		####UPGRADE04
		CruiseMissile = Class(TIFCruiseMissileLauncher) {},
    },

    OnCreate = function(self)
		TSeaUnit.OnCreate(self)
			##UPGRADE01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE02
			self:HideBone('Upgrade02_01', true)	
			self:HideBone('Upgrade02_02', true)	
			self:HideBone('Upgrade02_03', true)				
			##UPGRADE03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true) 
			##UPGRADE04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			###UPGRADE05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        TSeaUnit.OnStopBeingBuilt(self,builder,layer)
        self.Trash:Add(CreateRotator(self, 'Spinner01', 'y', nil, 360, 0, 180))
        self.Trash:Add(CreateRotator(self, 'Spinner02', 'y', nil, 90, 0, 180))
        self.Trash:Add(CreateRotator(self, 'Spinner03', 'y', nil, -180, 0, -180))
		
		self.Trash:Add(CreateRotator(self, 'Spinner04', 'y', nil, 180, 0, 180))
		self.Trash:Add(CreateRotator(self, 'Spinner05', 'y', nil, 180, 0, 180))
		
		self:SetWeaponEnabledByLabel('MainGun', true)
		self:SetWeaponEnabledByLabel('UpgradeGun01', false)
		self:SetWeaponEnabledByLabel('UpgradeGun02', false)
		
		self:SetWeaponEnabledByLabel('UpgradeAAGun01', false)
		self:SetWeaponEnabledByLabel('UpgradeAAGun02', false)
		
		self:SetWeaponEnabledByLabel('Torpedo01', false)
		self:SetWeaponEnabledByLabel('CruiseMissile', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)	
				self:HideBone('Origine01_01', true)	
				self:HideBone('Upgrade02_01', true)	
				self:HideBone('Upgrade02_02', true)	
				
				self:SetWeaponEnabledByLabel('UpgradeGun01', true)
				self:SetWeaponEnabledByLabel('UpgradeGun02', true)
				
				local wep1 = self:GetWeaponByLabel('UpgradeGun01')
				local wep2 = self:GetWeaponByLabel('UpgradeGun02')
				wep1:ChangeMaxRadius(28)
				wep2:ChangeMaxRadius(28)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 123,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)	
				self:ShowBone('Upgrade02_02', true)	
				self:ShowBone('Upgrade02_03', true)	
				self:HideBone('Origine02_01', true)
				
				self:SetWeaponEnabledByLabel('UpgradeAAGun01', true)
				self:SetWeaponEnabledByLabel('UpgradeAAGun02', true)
				local wep1 = self:GetWeaponByLabel('UpgradeGun01')
				local wep2 = self:GetWeaponByLabel('UpgradeGun02')
				wep1:AddDamageMod(bpEnh.CanonIDamageMod) 
				wep2:AddDamageMod(bpEnh.CanonIDamageMod) 
				local wep3 = self:GetWeaponByLabel('MainGun')
				wep3:AddDamageMod(bpEnh.CanonIDamageMod)  

				local wep4 = self:GetWeaponByLabel('UpgradeAAGun01')
				local wep5 = self:GetWeaponByLabel('UpgradeAAGun02')
				wep4:ChangeMaxRadius(35)
				wep5:ChangeMaxRadius(35)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)	
				self:ShowBone('Upgrade03_02', true)
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				self:SetWeaponEnabledByLabel('Torpedo01', true)
				
				local wep1 = self:GetWeaponByLabel('Torpedo01')
				wep1:ChangeMaxRadius(38)
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 200,
                            Mult = 1,
                        },	
						Health = {
                            Add = 350,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then

				self:ShowBone('Upgrade04_01', true)	
				self:ShowBone('Upgrade04_02', true)	
				self:SetWeaponEnabledByLabel('CruiseMissile', true)
				
				local wep1 = self:GetWeaponByLabel('CruiseMissile')
				wep1:ChangeMaxRadius(75)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 450,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)	
				self:SetIntelRadius('Vision', 50)
				self:SetIntelRadius('Radar', 120)
				self:SetIntelRadius('Sonar', 130)
				
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep2 = self:GetWeaponByLabel('CruiseMissile')
				
				local wep3 = self:GetWeaponByLabel('UpgradeGun01')
				local wep4 = self:GetWeaponByLabel('UpgradeGun02')
				
				local wep5 = self:GetWeaponByLabel('Torpedo01')
				
				wep1:ChangeMaxRadius(75)
				wep2:ChangeMaxRadius(85)
				
				wep3:ChangeMaxRadius(33)
				wep4:ChangeMaxRadius(33)
				
				wep5:ChangeMaxRadius(36)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
            end
		end	
	end,
	

}

TypeClass = UES0104