#****************************************************************************
#**
#**  File     :  /units/XSS0104/XSS0104_script.lua
#**
#**  Summary  :  Seraphim ARty Frigate Script: XSS0103
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local SSeaUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SSeaUnit
local SIFZthuthaamArtilleryCannon = import('/lua/seraphimweapons.lua').SIFZthuthaamArtilleryCannon
local SWeapon = import('/lua/seraphimweapons.lua')
local Buff = import('/lua/sim/Buff.lua')

###UPGRADE 04
local SDFUltraChromaticBeamGenerator = import('/lua/seraphimweapons.lua').SDFUltraChromaticBeamGenerator


XSS0104 = Class(SSeaUnit) {
    Weapons = {
        MainGun = Class(SIFZthuthaamArtilleryCannon) {},
	 	###UPGRADE01
		UpgradeAntiAir01 = Class(SWeapon.SAAShleoCannonWeapon){},
		UpgradeAntiAir02 = Class(SWeapon.SAAShleoCannonWeapon){},
		####UPGRADE 03
		AntiNavyUpgradeGun01 = Class(SWeapon.SDFShriekerCannon){},
		AntiNavyUpgradeGun02 = Class(SWeapon.SDFShriekerCannon){},
		####UPGRADE 04
		LaserGun01 = Class(SDFUltraChromaticBeamGenerator) {},
    },
	
    OnCreate = function(self)
		SSeaUnit.OnCreate(self)
			##UPGRADE 01
			self:HideBone('Upgrade01_01', true)  
			##UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			
			self:HideBone('Upgrade03_01', true)
			
			self:HideBone('Upgrade04_01', true)
			
			self:HideBone('Upgrade05_01', true)
			
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,	
	
    OnStopBeingBuilt = function(self,builder,layer)
        SSeaUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		###UPGRADE01
		self:SetWeaponEnabledByLabel('UpgradeAntiAir01', false)
		self:SetWeaponEnabledByLabel('UpgradeAntiAir02', false)
		####UPGRADE03
		self:SetWeaponEnabledByLabel('AntiNavyUpgradeGun01', false)
		self:SetWeaponEnabledByLabel('AntiNavyUpgradeGun02', false)
		####UPGRADE04
		self:SetWeaponEnabledByLabel('LaserGun01', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
			
				self:SetWeaponEnabledByLabel('UpgradeAntiAir01', true)
				self:SetWeaponEnabledByLabel('UpgradeAntiAir02', true)
				
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 103,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
			
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep3 = self:GetWeaponByLabel('UpgradeAntiAir01')
				local wep4 = self:GetWeaponByLabel('UpgradeAntiAir02')
				wep1:ChangeMaxRadius(77)
				wep3:ChangeMaxRadius(40)
				wep4:ChangeMaxRadius(40)
				
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 250,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		##########
		######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then

				self:ShowBone('Upgrade03_01', true)
				
				self:SetWeaponEnabledByLabel('AntiNavyUpgradeGun01', true)
				self:SetWeaponEnabledByLabel('AntiNavyUpgradeGun02', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade02SpeedMultiplier)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 350,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
			
				self:ShowBone('Upgrade04_01', true)
			
				self:SetWeaponEnabledByLabel('LaserGun01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade03SpeedMultiplier)
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 450,
                            Mult = 1.0,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then
				self:ShowBone('Upgrade05_01', true)

				self.Effect1 = CreateAttachedEmitter(self,'Rotator01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				self.Trash:Add(CreateRotator(self, 'Rotator01', 'y', nil, 100, 0, 100))
				
				self.Effect2 = CreateAttachedEmitter(self,'Rotator02',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct2)
				self.Trash:Add(CreateRotator(self, 'Rotator02', 'y', nil, 100, 0, 100))
				
				local wep1 = self:GetWeaponByLabel('MainGun')
				local wep3 = self:GetWeaponByLabel('UpgradeAntiAir01')
				local wep4 = self:GetWeaponByLabel('UpgradeAntiAir02')
				wep1:ChangeMaxRadius(82)
				wep3:ChangeMaxRadius(46)
				wep4:ChangeMaxRadius(46)
				
				wep1:AddDamageMod(bpEnh.FinalIDamageMod)
				wep3:AddDamageMod(bpEnh.FinalIIDamageMod)
				wep4:AddDamageMod(bpEnh.FinalIIDamageMod)
				
				
				local wep5 = self:GetWeaponByLabel('AntiNavyUpgradeGun01')
				local wep6 = self:GetWeaponByLabel('AntiNavyUpgradeGun02')
				wep5:ChangeMaxRadius(57)
				wep6:ChangeMaxRadius(57)
				wep5:AddDamageMod(bpEnh.FinalIIDamageMod)
				wep6:AddDamageMod(bpEnh.FinalIIDamageMod)
				
				local wep7 = self:GetWeaponByLabel('LaserGun01')
				wep7:ChangeMaxRadius(54)
				
				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
				BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 50,
                            Mult = 1,
                        },					
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,	
		
	
}
TypeClass = XSS0104
