#****************************************************************************
#**
#**  File     :  /data/units/XSA0202/XSA0202_script.lua
#**  Author(s):  Jessica St. Croix, Gordon Duclos, Matt Vainio, Aaron Lundquist
#**
#**  Summary  :  Seraphim Fighter/Bomber Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local SAirUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SAirUnit

local SeraphimWeapons = import('/lua/seraphimweapons.lua')
local SAAShleoCannonWeapon = SeraphimWeapons.SAAShleoCannonWeapon
local SDFBombOtheWeapon = SeraphimWeapons.SDFBombOtheWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSA0202 = Class(SAirUnit) {
    Weapons = {
        ShleoAAGun01 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
        ShleoAAGun02 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
        Bomb = Class(SDFBombOtheWeapon) {
                
            IdleState = State (SDFBombOtheWeapon.IdleState) {
                Main = function(self)
                    SDFBombOtheWeapon.IdleState.Main(self)
                end,
                
                OnGotTarget = function(self)
                    self.unit:SetBreakOffTriggerMult(2.0)
                    self.unit:SetBreakOffDistanceMult(8.0)
                    --self.unit:SetSpeedMult(0.67)
                    SDFBombOtheWeapon.OnGotTarget(self)
                end,                
            },
        
            OnGotTarget = function(self)
                self.unit:SetBreakOffTriggerMult(2.0)
                self.unit:SetBreakOffDistanceMult(8.0)
                --self.unit:SetSpeedMult(0.67)
                SDFBombOtheWeapon.OnGotTarget(self)
            end,
        
            OnLostTarget = function(self)
                self.unit:SetBreakOffTriggerMult(1.0)
                self.unit:SetBreakOffDistanceMult(1.0)
               -- self.unit:SetSpeedMult(1.0)
                SDFBombOtheWeapon.OnLostTarget(self)
            end,  	
        },
###############UPGRADE02
		ShleoAAGun03 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
        ShleoAAGun04 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },	
#############UPGRADE03
		ShleoAAGun05 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },
        ShleoAAGun06 = Class(SAAShleoCannonWeapon) {
			FxMuzzleFlash = {'/effects/emitters/sonic_pulse_muzzle_flash_02_emit.bp',},
        },		
    },
	
   OnCreate = function(self)
		SAirUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)			
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SAirUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('ShleoAAGun01', true)
			self:SetWeaponEnabledByLabel('ShleoAAGun02', true)
			self:SetWeaponEnabledByLabel('Bomb', true)
			###UPGRADE02
	        self:SetWeaponEnabledByLabel('ShleoAAGun03', false)  
			self:SetWeaponEnabledByLabel('ShleoAAGun04', false)
			###UPGRADE04
	        self:SetWeaponEnabledByLabel('ShleoAAGun05', false)  
			self:SetWeaponEnabledByLabel('ShleoAAGun06', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				local wep = self:GetWeaponByLabel('ShleoAAGun01')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)
				wep:ChangeMaxRadius(33)
				
				local wep2 = self:GetWeaponByLabel('ShleoAAGun02')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	
				wep2:ChangeMaxRadius(33)
				
				local wep3 = self:GetWeaponByLabel('ShleoAAGun03')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	 
				wep3:ChangeMaxRadius(33)				
				
				local wep4 = self:GetWeaponByLabel('ShleoAAGun04')
				wep4:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)
				wep4:ChangeMaxRadius(33)
				
				local wep5 = self:GetWeaponByLabel('ShleoAAGun05')
				wep5:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	
				wep5:ChangeMaxRadius(33)
				
				local wep6 = self:GetWeaponByLabel('ShleoAAGun06')
				wep6:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	 
				wep6:ChangeMaxRadius(33)	
				
				hasHEBI = true   
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetWeaponEnabledByLabel('ShleoAAGun03', true)  
				self:SetWeaponEnabledByLabel('ShleoAAGun04', true)
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				
				local wep = self:GetWeaponByLabel('ShleoAAGun01')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)
				wep:ChangeMaxRadius(35)
				wep:ChangeRateOfFire(1.1)  
				
				local wep2 = self:GetWeaponByLabel('ShleoAAGun02')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	
				wep2:ChangeMaxRadius(35)
				wep2:ChangeRateOfFire(1.1)  
				
				local wep3 = self:GetWeaponByLabel('ShleoAAGun03')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	 
				wep3:ChangeMaxRadius(35)				
				wep3:ChangeRateOfFire(1.1)  
				
				local wep4 = self:GetWeaponByLabel('ShleoAAGun04')
				wep4:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)
				wep4:ChangeMaxRadius(35)
				wep4:ChangeRateOfFire(1.1)  
				
				local wep5 = self:GetWeaponByLabel('ShleoAAGun05')
				wep5:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	
				wep5:ChangeMaxRadius(35)
				wep5:ChangeRateOfFire(1.1)  
				
				local wep6 = self:GetWeaponByLabel('ShleoAAGun06')
				wep6:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	 
				wep6:ChangeMaxRadius(35)	
				wep6:ChangeRateOfFire(1.1)  
				
				hasHEBI = true
				hasHEBII = true 
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },
					MaxHealth = {
                            Add = 200,
                            Mult = 1.0,
						},						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				
				self:SetWeaponEnabledByLabel('ShleoAAGun05', true)  
				self:SetWeaponEnabledByLabel('ShleoAAGun06', true)
				
				hasHEBI = true
				hasHEBII = true   
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end		
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then			
				self:ShowBone('Upgrade05_01', true)	
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade05_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 20,
                            Mult = 1,
                        },					
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,		
			
}
TypeClass = XSA0202