#****************************************************************************
#**
#**  File     :  /cdimage/units/UAA0203/UAA0203_script.lua
#**  Author(s):  Drew Staltman, Gordon Duclos
#**
#**  Summary  :  Seraphim Gunship Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local SAirUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SAirUnit

local SDFPhasicAutoGunWeapon = import('/lua/seraphimweapons.lua').SDFPhasicAutoGunWeapon

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSA0203 = Class(SAirUnit) {
    Weapons = {
        TurretLeft = Class(SDFPhasicAutoGunWeapon) {},
        TurretRight = Class(SDFPhasicAutoGunWeapon) {},
		###UPGRADE02
		TurretLeft01 = Class(SDFPhasicAutoGunWeapon) {},
        TurretRight01 = Class(SDFPhasicAutoGunWeapon) {},
		###UPGRADE04
		TurretLeft02 = Class(SDFPhasicAutoGunWeapon) {},
        TurretRight02 = Class(SDFPhasicAutoGunWeapon) {},
    },
	
   OnCreate = function(self)
		SAirUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)  			
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
    OnStopBeingBuilt = function(self, builder, layer)
        SAirUnit.OnStopBeingBuilt(self,builder,layer)
	        self:SetWeaponEnabledByLabel('TurretLeft', true)
			self:SetWeaponEnabledByLabel('TurretRight', true)
			###UPGRADE02
	        self:SetWeaponEnabledByLabel('TurretLeft01', false)  
			self:SetWeaponEnabledByLabel('TurretRight01', false)
			###UPGRADE04
	        self:SetWeaponEnabledByLabel('TurretLeft02', false)  
			self:SetWeaponEnabledByLabel('TurretRight02', false)
       self.WeaponsEnabled = true
	   self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		--local bp = self:GetBlueprint().Enhancements[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				
				self:HideBone('Origine01', true)	
				self:HideBone('Origine02', true)	
				
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				
				local wep = self:GetWeaponByLabel('TurretLeft')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)
				wep:ChangeMaxRadius(24)
				
				local wep2 = self:GetWeaponByLabel('TurretLeft01')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	
				wep2:ChangeMaxRadius(24)
				
				local wep3 = self:GetWeaponByLabel('TurretLeft02')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	 
				wep3:ChangeMaxRadius(24)				
				
				local wep4 = self:GetWeaponByLabel('TurretRight')
				wep4:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)
				wep4:ChangeMaxRadius(24)
				
				local wep5 = self:GetWeaponByLabel('TurretRight01')
				wep5:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	
				wep5:ChangeMaxRadius(24)
				
				local wep6 = self:GetWeaponByLabel('TurretRight02')
				wep6:AddDamageMod(bpEnh.SonicPulseBatteryIDamageMod)	 
				wep6:ChangeMaxRadius(24)	
				
				hasHEBI = true   
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 100,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################	
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true)
				
				self:SetWeaponEnabledByLabel('TurretLeft01', true)  
				self:SetWeaponEnabledByLabel('TurretRight01', true)
			
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 150,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then
				self:ShowBone('Upgrade03_01', true)
				
				local wep = self:GetWeaponByLabel('TurretLeft')
				wep:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)
				wep:ChangeMaxRadius(26)
				wep:ChangeRateOfFire(1.37)  
				
				local wep2 = self:GetWeaponByLabel('TurretLeft01')
				wep2:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	
				wep2:ChangeMaxRadius(26)
				wep2:ChangeRateOfFire(1.37)  
				
				local wep3 = self:GetWeaponByLabel('TurretLeft02')
				wep3:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	 
				wep3:ChangeMaxRadius(26)				
				wep3:ChangeRateOfFire(1.37)  
				
				local wep4 = self:GetWeaponByLabel('TurretRight')
				wep4:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)
				wep4:ChangeMaxRadius(26)
				wep4:ChangeRateOfFire(1.37)  
				
				local wep5 = self:GetWeaponByLabel('TurretRight01')
				wep5:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	
				wep5:ChangeMaxRadius(26)
				wep5:ChangeRateOfFire(1.37)  
				
				local wep6 = self:GetWeaponByLabel('TurretRight02')
				wep6:AddDamageMod(bpEnh.SonicPulseBatteryIIDamageMod)	 
				wep6:ChangeMaxRadius(26)	
				wep6:ChangeRateOfFire(1.37)  
				
				hasHEBI = true
				hasHEBII = true 
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 250,
                            Mult = 1.0,
                        },
					MaxHealth = {
                            Add = 200,
                            Mult = 1.0,
						},						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				
				self:SetWeaponEnabledByLabel('TurretLeft02', true)  
				self:SetWeaponEnabledByLabel('TurretRight02', true)
				
				hasHEBI = true
				hasHEBII = true   
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end		
		#######################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then			
				self:ShowBone('Upgrade05_01', true)	
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade05_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)				
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = true
			BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
							Regen = {
                            Add = 20,
                            Mult = 1,
                        },					
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
end,		
		
	
}
TypeClass = XSA0203