#****************************************************************************
#**
#**  File     :  /cdimage/units/XSS0201/XSS0201_script.lua
#**  Author(s):  Greg Kohne, Gordon Duclos, Aaron Lundquist
#**
#**  Summary  :  Seraphim Destroyer Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
local SSubUnit = import('/lua/seraphimunits.lua').SSubUnit
local SeraphimWeapons = import('/lua/seraphimweapons.lua')
local SDFUltraChromaticBeamGenerator = SeraphimWeapons.SDFUltraChromaticBeamGenerator02
local SANAnaitTorpedo = SeraphimWeapons.SANAnaitTorpedo
local SDFAjelluAntiTorpedoDefense = SeraphimWeapons.SDFAjelluAntiTorpedoDefense
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false # Flag signalant Enhancement avec Heavy Electron Bolter
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSS0201 = Class(SSubUnit) {
    BackWakeEffect = {},
    Weapons = {
        FrontTurret01 = Class(SDFUltraChromaticBeamGenerator) {},
		FrontTurret02 = Class(SDFUltraChromaticBeamGenerator) {},
        ##MUST STAY OFF
		BackTurret = Class(SDFUltraChromaticBeamGenerator) {},
        Torpedo1 = Class(SANAnaitTorpedo) {},
        AntiTorpedo = Class(SDFAjelluAntiTorpedoDefense) {},
		###UPGRADE02
		Torpedo2 = Class(SANAnaitTorpedo) {},
		###UPGRADE04
		UpgradeTurret01 = Class(SDFUltraChromaticBeamGenerator) {}, 
		UpgradeTurret02 = Class(SDFUltraChromaticBeamGenerator) {}, 
    },


    OnCreate = function(self)
        SSubUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true) 
		self:HideBone('Upgrade01_02', true)
		###UPGRADE02
        self:HideBone('Upgrade02_01', true)		
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		self:HideBone('Upgrade03_03', true) 
		###UPGRADE04 	
		self:HideBone('Upgrade04_01', true)
		self:HideBone('Upgrade04_02', true)
		self:HideBone('Upgrade04_03', true) 		
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false		
	
    end,	
	
	
	OnStopBeingBuilt = function(self, builder, layer)
		SSubUnit.OnStopBeingBuilt(self, builder, layer)
		###UPGRADE0
		self:SetWeaponEnabledByLabel('BackTurret', false)
		###UPGRADE01
		###UPGRADE02
		self:SetWeaponEnabledByLabel('Torpedo2', false)		
		###UPGRADE04
		self:SetWeaponEnabledByLabel('UpgradeTurret01', false)
		self:SetWeaponEnabledByLabel('UpgradeTurret02', false)			
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
		IssueDive({self})
	end,  

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
		self:ShowBone('Upgrade01_01', true) 
		self:ShowBone('Upgrade01_02', true)	
		self:SetIntelRadius('Sonar', 60)
		local wep01 = self:GetWeaponByLabel('Torpedo1')
		local wep02 = self:GetWeaponByLabel('Torpedo2')
		local wep03 = self:GetWeaponByLabel('AntiTorpedo')
		wep01:ChangeMaxRadius(68)
		wep02:ChangeMaxRadius(68)
		wep03:ChangeMaxRadius(0.52)
				hasHEBI = true    # Signale HEB INSTALL
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false			

            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				self:ShowBone('Upgrade02_01', true) 
				self:SetWeaponEnabledByLabel('Torpedo1', false)
				self:SetWeaponEnabledByLabel('Torpedo2', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false		
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then			
				self:ShowBone('Upgrade03_01', true) 
				self:ShowBone('Upgrade03_02', true) 
				self:ShowBone('Upgrade03_03', true) 
				self:HideBone('Upgrade01_02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 4000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true) 
				self:ShowBone('Upgrade04_02', true) 
				self:ShowBone('Upgrade04_03', true) 
				self:SetWeaponEnabledByLabel('UpgradeTurret01', true)	
				self:SetWeaponEnabledByLabel('UpgradeTurret02', true)	
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            end
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	

				
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFF',
                    DisplayName = 'UEFHEALTHBUFF',
                    BuffType = 'MAXHEALTH',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 5000,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFF')
		end		
	end,	
	
    OnKilled = function(self, instigator, type, overkillRatio)       
        SSubUnit.OnKilled(self, instigator, type, overkillRatio)
    end,
    
    #OnMotionVertEventChange = function( self, new, old )
    #    SSubUnit.OnMotionVertEventChange(self, new, old)
    #    if new == 'Top' then
    #        self:SetWeaponEnabledByLabel('FrontTurret', true)
    #        self:SetWeaponEnabledByLabel('BackTurret', true)
    #   elseif new == 'Down' then
    #        self:SetWeaponEnabledByLabel('FrontTurret', false)
    #        self:SetWeaponEnabledByLabel('BackTurret', false)
    #    end
    #end,
    

}
TypeClass = XSS0201