#****************************************************************************
#**
#**  File     :  /units/UAL0305/UAL0305_script.lua
#**  Author(s):  John Comes, David Tomandl
#**
#**  Summary  :  Aeon Heavy Tank Tech3 Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************


#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local ALandUnit = import( MyModPath .. '/hook/lua/aeonunits.lua' ).ALandUnit

local ADFQuantumAutogunWeapon = import('/lua/aeonweapons.lua').ADFQuantumAutogunWeapon
###UPGRADE03
local ADFDisruptorCannonWeapon = import('/lua/aeonweapons.lua').ADFDisruptorWeapon
###/03
local EffectUtil = import('/lua/EffectUtilities.lua')

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false




UAL0305 = Class( ALandUnit ) {
    Weapons = {
        MainGun = Class(ADFQuantumAutogunWeapon) {
            FxMuzzleFlash = { 
                '/effects/emitters/aeon_heavy_artillery_flash_01_emit.bp', 
                '/effects/emitters/aeon_heavy_artillery_flash_02_emit.bp', 
            },
        },
		###UPGRADE2
		Upgrade02Weapon = Class(ADFQuantumAutogunWeapon) {
            FxMuzzleFlash = { 
                '/effects/emitters/aeon_heavy_artillery_flash_01_emit.bp', 
                '/effects/emitters/aeon_heavy_artillery_flash_02_emit.bp', 
            },
        },
		###UPGRADE3
		Upgrade03Weapon = Class(ADFDisruptorCannonWeapon) {
			CreateProjectileAtMuzzle = function(self, muzzle)
                local proj = ADFDisruptorCannonWeapon.CreateProjectileAtMuzzle(self, muzzle)
                local data = self:GetBlueprint().DamageToShields
                if proj and not proj:BeenDestroyed() then
                    proj:PassData(data)
                end
            end,
		},
    },
	
	OnCreate = function(self)
        ALandUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		self:HideBone('Upgrade01_03', true)
		self:HideBone('Upgrade01_04', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,
	
	OnStopBeingBuilt = function(self,builder,layer)
        ALandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		########UPGRADE02
		self:SetWeaponEnabledByLabel('Upgrade02Weapon', false)
		########UPGRADE02
		self:SetWeaponEnabledByLabel('Upgrade03Weapon', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
		
    end,	
	
#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Range 10%
				local wep = self:GetWeaponByLabel('MainGun')
				wep:ChangeMaxRadius(33)
				local wep2 = self:GetWeaponByLabel('Upgrade02Weapon')
				wep2:ChangeMaxRadius(33)
				local wep3 = self:GetWeaponByLabel('Upgrade03Weapon')
				wep3:ChangeMaxRadius(33)
				###Damages 10%
				wep:AddDamageMod(bpEnh.QuantumIDamageMod)
				###Meshe
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFI',
                    DisplayName = 'AEONHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 178,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###Range 10%
				local wep = self:GetWeaponByLabel('MainGun')
				wep:ChangeMaxRadius(38)				
				local wep2 = self:GetWeaponByLabel('Upgrade02Weapon')
				wep2:ChangeMaxRadius(38)
				local wep3 = self:GetWeaponByLabel('Upgrade03Weapon')
				wep3:ChangeMaxRadius(38)
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade02Weapon', true)
				###Meshe
				self:ShowBone('Upgrade02_01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFII',
                    DisplayName = 'AEONHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				###Meshe
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade03Weapon', true)
				###Range Medium
				local wep3 = self:GetWeaponByLabel('Upgrade03Weapon')
				wep3:ChangeMaxRadius(45)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIII',
                    DisplayName = 'AEONHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				###Range 15%
				local wep = self:GetWeaponByLabel('MainGun')
				wep:ChangeMaxRadius(43)				
				local wep2 = self:GetWeaponByLabel('Upgrade02Weapon')
				wep2:ChangeMaxRadius(43)
				local wep3 = self:GetWeaponByLabel('Upgrade03Weapon')
				wep3:ChangeMaxRadius(52)
				###Meshe
				self:ShowBone('Upgrade04_01', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIV',
                    DisplayName = 'AEONHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				###Meshe
				self:ShowBone('Upgrade05_01', true)
				###Heeavy Shield
				self:DestroyShield()
				ForkThread(function()
					WaitTicks(1)
					self:CreateShield(bpEnh)
					self:SetEnergyMaintenanceConsumptionOverride(bpEnh.MaintenanceConsumptionPerSecondEnergy or 0)
					self:SetMaintenanceConsumptionActive()
				end)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFV',
                    DisplayName = 'AEONHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFV')
		end		
	end,			
	

}

TypeClass = UAL0305
