#****************************************************************************
#**
#**  File     :  /cdimage/units/UEL0303/UEL0303_script.lua
#**  Author(s):  John Comes, David Tomandl, Jessica St. Croix
#**
#**  Summary  :  UEF Siege Assault Bot Script
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


local TerranWeaponFile = import('/lua/terranweapons.lua')

local TWalkingLandUnit = import( MyModPath .. '/hook/lua/terranunits.lua').TWalkingLandUnit
local TDFHeavyPlasmaCannonWeapon = TerranWeaponFile.TDFHeavyPlasmaCannonWeapon
local TIFCruiseMissileUnpackingLauncher = TerranWeaponFile.TIFCruiseMissileUnpackingLauncher

local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

UEL0303 = Class(TWalkingLandUnit) {

    Weapons = {
        HeavyPlasma01 = Class(TDFHeavyPlasmaCannonWeapon) {
            DisabledFiringBones = {
                'Torso', 'ArmG_B02', 'Barrel_G', 'ArmG_B03', 'ArmG_B04',
                'ArmD_B02', 'Barrel_D', 'ArmD_B03', 'ArmD_B04',
            },
        },
		####UPGRADE 2
		HeavyPlasma02 = Class(TDFHeavyPlasmaCannonWeapon) {},
		####UPGRADE 3
        MissileWeapon01 = Class(TIFCruiseMissileUnpackingLauncher) {},

    },
	
    OnCreate = function(self)
        TWalkingLandUnit.OnCreate(self)
		###UPGRADE01
		self:HideBone('Upgrade01_01', true)
		self:HideBone('Upgrade01_02', true)
		self:HideBone('Upgrade01_03', true)
		###UPGRADE02
		self:HideBone('Upgrade02_01', true)
		self:HideBone('Upgrade02_02', true)
		###UPGRADE03
		self:HideBone('Upgrade03_01', true)
		self:HideBone('Upgrade03_02', true)
		###UPGRADE04 
		self:HideBone('Upgrade04_01', true)
		self:HideBone('Upgrade04_02', true)
		self:HideBone('Upgrade04_03', true)
		###UPGRADE05 
		self:HideBone('Upgrade05_01', true)
		self:HideBone('Upgrade05_02', true)
		self.hasHEBI = false
		self.hasHEBII = false
		self.hasHEBIII = false
		self.hasHEBIV = false
		self.hasHEBV = false	
    end,	
	
	OnStopBeingBuilt = function(self, builder,layer)
        TWalkingLandUnit.OnStopBeingBuilt(self, builder,layer)
		self:SetWeaponEnabledByLabel('HeavyPlasma01', true)

		###UPGRADE02
		self:SetWeaponEnabledByLabel('HeavyPlasma02', false)
		###UPGRADE03
		self:SetWeaponEnabledByLabel('MissileWeapon01', false)
	
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 			
    end,	
	
	
	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				--###Speed 10%
				--self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				###Damages 10%
				local wep = self:GetWeaponByLabel('HeavyPlasma01')
				wep:AddDamageMod(bpEnh.PlasmaIDamageMod)
				###Bones
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFI',
                    DisplayName = 'UEFHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 109.9,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon				
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)
				self:SetWeaponEnabledByLabel('HeavyPlasma02', true)

				
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFII',
                    DisplayName = 'UEFHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                            Add = 10,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
			
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				self:SetWeaponEnabledByLabel('MissileWeapon01', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		

                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIII',
                    DisplayName = 'UEFHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 35,
                            Mult = 0.9,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'UEFHEALTHBUFFIV',
                    DisplayName = 'UEFHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 277,
                            Mult = 1.0,
                        },
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				self:ShowBone('Upgrade05_01', true)
				self:ShowBone('Upgrade05_02', true)
				###Speed -30%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'UEFHEALTHBUFFV',
                    DisplayName = 'UEFHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        MaxHealth = {
                            Add = 195,
                            Mult = 1.0,
                        },
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'UEFHEALTHBUFFV')
		end		
	end,		
    
}

TypeClass = UEL0303