#****************************************************************************
#**
#**  File     :  /cdimage/units/XSL0304/XSL0304_script.lua
#**  Author(s):  John Comes, David Tomandl, Matt Vainio, Aaron Lundquist
#**
#**  Summary  :  Seraphim Mobile Heavy Artillery
#**
#**  Copyright  2005 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local SWalkingLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SWalkingLandUnit
local SIFSuthanusArtilleryCannon = import('/lua/seraphimweapons.lua').SIFSuthanusMobileArtilleryCannon

local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false 
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSL0304 = Class(SWalkingLandUnit) {
    Weapons = {
        MainGun = Class(SIFSuthanusArtilleryCannon) {},
		###02
		Upgrade02Gun = Class(SIFSuthanusArtilleryCannon) {},
		###03
		Upgrade03Gun = Class(SIFSuthanusArtilleryCannon) {},
    },
 
	OnCreate = function(self)
		SWalkingLandUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)
			self:HideBone('Upgrade01_03', true)
			self:HideBone('Upgrade01_04', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade02_02', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			self:HideBone('Upgrade04_03', true)
			self:HideBone('Upgrade04_04', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
	OnStopBeingBuilt = function(self,builder,layer)
        SWalkingLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('MainGun', true)
		###UPGRADE 2
		self:SetWeaponEnabledByLabel('Upgrade02Gun', false)
		###UPGRADE 3
		self:SetWeaponEnabledByLabel('Upgrade03Gun', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
		
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 20%
				local wep = self:GetWeaponByLabel('MainGun')
				wep:AddDamageMod(bpEnh.ArtyIDamageMod)
				###Speed 10%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				###Meshe
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				self:ShowBone('Upgrade01_03', true)
				self:ShowBone('Upgrade01_04', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFI',
                    DisplayName = 'AEONHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade02Gun', true)
				###Meshe
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)
				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFII',
                    DisplayName = 'AEONHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                         Add = 680,
                         Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				###Meshe
				self:ShowBone('Upgrade03_01', true)
				###New Weapon
				self:SetWeaponEnabledByLabel('Upgrade03Gun', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIII',
                    DisplayName = 'AEONHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				###Advanced Regen
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade05_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				###Meshe
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				self:ShowBone('Upgrade04_03', true)
				self:ShowBone('Upgrade04_04', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIV',
                    DisplayName = 'AEONHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
						Regen = {
                            Add = 40,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				###Meshe
				self:ShowBone('Upgrade05_01', true)
				###Teleport
				self:AddCommandCap('RULEUCC_Teleport')				
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFV',
                    DisplayName = 'AEONHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFV')
		end		
	end,			 
 
}

TypeClass = XSL0304