#****************************************************************************
#**
#**  File     :  /data/units/XSL0305/XSL0305_script.lua
#**
#**  Summary  :  Seraphim Sniper Bot Script
#**
#**  Copyright  2007 Gas Powered Games, Inc.  All rights reserved.
#****************************************************************************
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
local Game = import( '/lua/game.lua' )

# VARIABLE ''GLOBALE'' ( par Manimal )
local MyModPath = Game.MyModPath
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local SLandUnit = import( MyModPath .. '/hook/lua/seraphimunits.lua').SLandUnit

local SeraphimWeapons = import('/lua/seraphimweapons.lua')

local SDFSihEnergyRifleNormalMode = SeraphimWeapons.SDFSniperShotNormalMode
local SDFSihEnergyRifleSniperMode = SeraphimWeapons.SDFSniperShotSniperMode

###UPGRADE03 weapon
local SDFUltraChromaticBeamGenerator = import('/lua/seraphimweapons.lua').SDFUltraChromaticBeamGenerator

local EffectUtil = import('/lua/EffectUtilities.lua')
local Buff = import('/lua/sim/Buff.lua')

local hasHEBI = false 
local hasHEBII = false
local hasHEBI = false
local hasHEBIV = false
local hasHEBV = false

XSL0305 = Class(SLandUnit) {

    Weapons = {
        SniperGun = Class(SDFSihEnergyRifleSniperMode) {},
		###UPGRADE02
		SniperGun02 = Class(SDFSihEnergyRifleSniperMode) {},
		###UPGRADE03
		LaserGun = Class(SDFUltraChromaticBeamGenerator) {},
    },

OnCreate = function(self)
		SLandUnit.OnCreate(self)
			self:HideBone('Upgrade01_01', true)
			self:HideBone('Upgrade01_02', true)
			########UPGRADE 02
			self:HideBone('Upgrade02_01', true)
			self:HideBone('Upgrade02_02', true)
			########UPGRADE 03
			self:HideBone('Upgrade03_01', true)
			self:HideBone('Upgrade03_02', true)
			########UPGRADE 04
			self:HideBone('Upgrade04_01', true)
			self:HideBone('Upgrade04_02', true)
			########UPGRADE 05
			self:HideBone('Upgrade05_01', true)
			self.hasHEBI = false
			self.hasHEBII = false
			self.hasHEBIII = false
			self.hasHEBIV = false
			self.hasHEBV = false
    end,
	
	OnStopBeingBuilt = function(self,builder,layer)
        SLandUnit.OnStopBeingBuilt(self,builder,layer)
		self:SetWeaponEnabledByLabel('SniperGun', true)
		###UPGRADE 2
		self:SetWeaponEnabledByLabel('SniperGun02', false)
		###UPGRADE 3
		self:SetWeaponEnabledByLabel('LaserGun', false)
		self.WeaponsEnabled = true
		self:AddUnitCallback(self.OnVeteran, 'OnVeteran') 
		
    end,

	#Level#
	OnVeteran = function ( self )
        local bp = self:GetBlueprint()
		local enh = 'VeterancyI'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyI' then	
				###Damages 20%
				local wep = self:GetWeaponByLabel('SniperGun')
				wep:AddDamageMod(bpEnh.SniperIDamageMod)
				###Speed 10%
				self:SetSpeedMult(bp.Physics.Upgrade01SpeedMultiplier)
				###Meshe
				self:ShowBone('Upgrade01_01', true)
				self:ShowBone('Upgrade01_02', true)
				hasHEBI = true
				hasHEBII = false
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
				###HP 20%		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFI',
                    DisplayName = 'AEONHEALTHBUFFI',
                    BuffType = 'MAXHEALTHI',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFI')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyII' then
				###New Weapon
				self:SetWeaponEnabledByLabel('SniperGun02', true)
				###Meshe
				self:ShowBone('Upgrade02_01', true)
				self:ShowBone('Upgrade02_02', true)

				hasHEBI = true
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = false
				hasHEBIV = false
				hasHEBV = false	
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFII',
                    DisplayName = 'AEONHEALTHBUFFII',
                    BuffType = 'MAXHEALTHII',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						MaxHealth = {
                         Add = 80,
                         Mult = 1.0,
                        },
                        Health = {
                            Add = 500,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIII'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIII' then	
				###Meshe
				self:ShowBone('Upgrade03_01', true)
				self:ShowBone('Upgrade03_02', true)
				###New Weapon
				self:SetWeaponEnabledByLabel('LaserGun', true)
				###Range Medium
				local wep3 = self:GetWeaponByLabel('LaserGun')
				wep3:ChangeMaxRadius(60)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = false
				hasHEBV = false		
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIII',
                    DisplayName = 'AEONHEALTHBUFFIII',
                    BuffType = 'MAXHEALTHIII',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIII')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyIV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyIV' then
				###Advanced Regen
				self.Effect1 = CreateAttachedEmitter(self,'Upgrade04_01',self:GetArmy(), '/effects/emitters/seraphim_being_built_ambient_02_emit.bp')
				self.Trash:Add(self.Effecct1)
				###Meshe
				self:ShowBone('Upgrade04_01', true)
				self:ShowBone('Upgrade04_02', true)
				hasHEBI = true
				hasHEBII = true
				hasHEBIII = true
				hasHEBIV = true
				hasHEBV = false
            BuffBlueprint {
                    Name = 'AEONHEALTHBUFFIV',
                    DisplayName = 'AEONHEALTHBUFFIV',
                    BuffType = 'MAXHEALTHIIV',
					Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
						Health = {
                            Add = 500,
                            Mult = 1.0,
                        },
						Regen = {
                            Add = 40,
                            Mult = 1,
                        },	
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFIV')
		end	
	##################################
        local bp = self:GetBlueprint()
		local enh = 'VeterancyV'
		local bpEnh = bp.ExpeWars_Enhancement[enh]
		if not bpEnh then return end
        local bpEnhEAVLevel = bpEnh.EnabledAtVeterancyLevel
		# ADDS MY CUSTOM ENHANCEMENT !
		if bpEnhEAVLevel and bpEnhEAVLevel > 0 and ( self.VeteranLevel == bpEnhEAVLevel ) then
			if enh =='VeterancyV' then	
				###Meshe
				self:ShowBone('Upgrade05_01', true)
				###Teleport
				self:AddCommandCap('RULEUCC_Teleport')				
				hasHEBI = true  
				hasHEBII = true    # Signale HEB INSTALL
				hasHEBIII = true	
				hasHEBIV = true
				hasHEBV = true
                BuffBlueprint {
                    Name = 'AEONHEALTHBUFFV',
                    DisplayName = 'AEONHEALTHBUFFV',
                    BuffType = 'MAXHEALTHV',
                    Stacks = 'REPLACE',
                    Duration = -1,
                    Affects = {
                        Health = {
                            Add = 2000,
                            Mult = 1.0,
                        },						
                    },
                }
            end
			Buff.ApplyBuff(self, 'AEONHEALTHBUFFV')
		end		
	end,			
	

}

TypeClass = XSL0305